/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.cache.HardReferenceQueueEvictionListener;
import com.bigdata.cache.IHardReferenceQueue;
import com.bigdata.cache.RingBuffer;

public class HardReferenceQueue<T>
extends RingBuffer<T>
implements IHardReferenceQueue<T> {
    private final HardReferenceQueueEvictionListener<T> listener;
    protected final int nscan;

    public HardReferenceQueue(HardReferenceQueueEvictionListener<T> listener, int capacity) {
        this(listener, capacity, Math.min(capacity, 10));
    }

    public HardReferenceQueue(HardReferenceQueueEvictionListener<T> listener, int capacity, int nscan) {
        super(capacity);
        if (nscan < 0 || nscan > capacity) {
            throw new IllegalArgumentException();
        }
        this.listener = listener;
        this.nscan = nscan;
    }

    public final HardReferenceQueueEvictionListener<T> getListener() {
        return this.listener;
    }

    @Override
    public final int nscan() {
        return this.nscan;
    }

    @Override
    public boolean add(T ref) {
        if (this.nscan > 0 && this.scanHead(this.nscan, ref)) {
            return false;
        }
        super.add(ref);
        return true;
    }

    @Override
    protected void beforeOffer(T ref) {
        if (this.size == this.capacity) {
            this.evict();
        }
    }

    @Override
    public final boolean evict() {
        Object ref = this.poll();
        if (ref == null) {
            return false;
        }
        if (this.listener != null) {
            this.listener.evicted(this, ref);
        }
        return true;
    }

    @Override
    public final void evictAll(boolean clearRefs) {
        if (clearRefs) {
            while (!this.isEmpty()) {
                this.evict();
            }
        } else {
            int size = this.size();
            for (int n = 0; n < size; ++n) {
                Object ref = this.get(n);
                if (this.listener == null) continue;
                this.listener.evicted(this, ref);
            }
        }
    }
}

