/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.tools;

import java.sql.SQLException;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.arq.querybuilder.WhereBuilder;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.E_StrReplace;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.lang.sparql_11.ParseException;
import org.apache.jena.update.UpdateRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class RenamingTool {
    String strMatch;
    String strTarget;
    String strReplacement;
    Expr exprFilter = null;
    boolean splitUpdate = true;
    int stepSize = 1000000;
    boolean quads = true;
    ExprFactory exprFactory = new ExprFactory();
    static String varCount = "count";
    static Var varTargetURI = Var.alloc((String)"targetURI");
    static ExprVar exprTargetURI = new ExprVar(varTargetURI);
    static Var varReplacementURI = Var.alloc((String)"replacementURI");
    static ExprVar exprReplacementURI = new ExprVar(varReplacementURI);
    Expr exprMatch;
    Expr exprTarget;
    static Var newS = Var.alloc((String)"newS");
    static Var newP = Var.alloc((String)"newP");
    static Var newO = Var.alloc((String)"newO");
    static Var varS = Var.alloc((String)"s");
    static Var varP = Var.alloc((String)"p");
    static Var varO = Var.alloc((String)"o");
    static Var varG = Var.alloc((String)"g");
    public static ExprVar exprS = new ExprVar(varS);
    public static ExprVar exprP = new ExprVar(varP);
    public static ExprVar exprO = new ExprVar(varO);
    public static ExprVar exprG = new ExprVar(varG);
    static Var matchS = Var.alloc((String)"matchS");
    static Var matchP = Var.alloc((String)"matchP");
    static Var matchO = Var.alloc((String)"matchO");
    static ExprVar exprMatchS = new ExprVar(matchS);
    static ExprVar exprMatchP = new ExprVar(matchP);
    static ExprVar exprMatchO = new ExprVar(matchO);

    public RenamingTool(String strTarget, String strReplacement) {
        this.strMatch = strTarget;
        this.strTarget = strTarget;
        this.strReplacement = strReplacement;
    }

    public RenamingTool(String strMatch, String strTarget, String strReplacement) {
        this.strMatch = strMatch;
        this.strTarget = strTarget;
        this.strReplacement = strReplacement;
    }

    public void setFilter(Expr filter) {
        this.exprFilter = filter;
    }

    public void setMatch(String match) {
        this.strMatch = match;
    }

    public void setTarget(String target) {
        this.strTarget = target;
    }

    public void setReplacement(String replacement) {
        this.strReplacement = replacement;
    }

    public void setUpdateSize(int updateSize) {
        this.splitUpdate = true;
        this.stepSize = updateSize;
    }

    public void setSingleUpdate() {
        this.splitUpdate = false;
    }

    public void setTripleStore() {
        this.quads = false;
    }

    public void setQuadsStore() {
        this.quads = true;
    }

    public void renameString(StoreClientInterface kbClient) {
        this.renameString(kbClient, null);
    }

    public void renameString(StoreClientInterface kbClient, String graph) {
        if (this.strTarget == null || this.strReplacement == null) {
            throw new JPSRuntimeException("RenamingTool: target or replacement is null!");
        }
        if (this.strMatch == null) {
            this.strMatch = this.strTarget;
        }
        this.exprMatch = this.exprFactory.asExpr((Object)this.strMatch);
        this.exprTarget = this.exprFactory.asExpr((Object)this.strTarget);
        WhereBuilder whereFilter = this.whereMatchString();
        WhereBuilder whereUpdate = this.whereUpdateString();
        this.performRename(kbClient, graph, whereFilter, whereUpdate);
    }

    public void renameIRI(StoreClientInterface kbClient) {
        this.renameIRI(kbClient, null);
    }

    public void renameIRI(StoreClientInterface kbClient, String graph) {
        if (this.strTarget == null || this.strReplacement == null) {
            throw new JPSRuntimeException("RenamingTool: target or replacement is null!");
        }
        WhereBuilder whereUpdate = this.whereUpdateIRI();
        WhereBuilder whereFilter = this.whereMatchIRI();
        this.performRename(kbClient, graph, whereFilter, whereUpdate);
    }

    private void performRename(StoreClientInterface kbClient, String graph, WhereBuilder whereMatch, WhereBuilder whereUpdate) {
        if (this.splitUpdate) {
            String query = this.countQuery(graph, whereMatch);
            JSONArray result = kbClient.executeQuery(query);
            JSONObject jsonobject = result.getJSONObject(0);
            int count = jsonobject.getInt(varCount);
            int steps = count / this.stepSize;
            if (count % this.stepSize > 0) {
                ++steps;
            }
            UpdateRequest sparqlUpdate = this.buildSparqlUpdate(graph, whereUpdate, this.stepSize);
            for (int i = 0; i < steps; ++i) {
                try {
                    kbClient.executeUpdate(sparqlUpdate);
                    continue;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof SQLException) {
                        throw new JPSRuntimeException("RenamingTool: tagging update failed! SourceKB might not be quads. Try setTripleStore().", e);
                    }
                    throw e;
                }
            }
            result = kbClient.executeQuery(query);
            jsonobject = result.getJSONObject(0);
            count = jsonobject.getInt(varCount);
            if (count > 0) {
                sparqlUpdate = this.buildSparqlUpdate(graph, whereUpdate, 0);
                kbClient.executeUpdate(sparqlUpdate);
            }
        } else {
            UpdateRequest sparqlUpdate = this.buildSparqlUpdate(graph, whereUpdate, 0);
            kbClient.executeUpdate(sparqlUpdate);
        }
    }

    private String countQuery(String graph, WhereBuilder whereFilter) {
        WhereBuilder where = null;
        if (graph != null) {
            where = new WhereBuilder();
            String graphURI = "<" + graph + ">";
            where.addGraph((Object)graphURI, (AbstractQueryBuilder)whereFilter);
        } else {
            where = whereFilter;
        }
        String query = "SELECT (COUNT(*) AS ?" + varCount + ") ";
        query = query + where.toString();
        return query;
    }

    private UpdateRequest buildSparqlUpdate(String graph, WhereBuilder where, int limit) {
        SelectBuilder select = new SelectBuilder();
        select.addVar((Object)varS).addVar((Object)varP).addVar((Object)varO).addVar((Object)newS).addVar((Object)newP).addVar((Object)newO);
        if (limit > 0) {
            select.setLimit(limit);
        }
        UpdateBuilder builder = new UpdateBuilder();
        if (this.quads) {
            if (graph == null) {
                select.addVar((Object)varG);
                select.addGraph((Object)varG, (AbstractQueryBuilder)where);
                builder.addInsert((Object)varG, (Object)newS, (Object)newP, (Object)newO).addDelete((Object)varG, (Object)varS, (Object)varP, (Object)varO).addSubQuery((AbstractQueryBuilder)select);
            } else {
                String graphURI = "<" + graph + ">";
                select.addGraph((Object)graphURI, (AbstractQueryBuilder)where);
                builder.addInsert((Object)graphURI, (Object)newS, (Object)newP, (Object)newO).addDelete((Object)graphURI, (Object)varS, (Object)varP, (Object)varO).addSubQuery((AbstractQueryBuilder)select);
            }
        } else {
            select.addWhere((AbstractQueryBuilder)where);
            builder.addInsert((Object)newS, (Object)newP, (Object)newO).addDelete((Object)varS, (Object)varP, (Object)varO).addSubQuery((AbstractQueryBuilder)select);
        }
        return builder.buildRequest();
    }

    private WhereBuilder whereMatchIRI() {
        E_Equals eqS = this.exprFactory.eq((Object)exprS, (Object)exprTargetURI);
        E_Equals eqP = this.exprFactory.eq((Object)exprP, (Object)exprTargetURI);
        E_Equals eqO = this.exprFactory.eq((Object)exprO, (Object)exprTargetURI);
        E_LogicalOr orSPO = this.exprFactory.or((Object)eqS, (Object)this.exprFactory.or((Object)eqP, (Object)eqO));
        WhereBuilder where = new WhereBuilder();
        if (this.exprFilter != null) {
            where.addFilter(this.exprFilter);
        }
        try {
            where.addWhere((Object)varS, (Object)varP, (Object)varO).addBind("<" + this.strTarget + ">", (Object)varTargetURI).addBind("<" + this.strReplacement + ">", (Object)varReplacementURI).addFilter((Expr)orSPO);
        }
        catch (ParseException e) {
            throw new JPSRuntimeException(e);
        }
        return where;
    }

    private WhereBuilder whereUpdateIRI() {
        E_Conditional ifS = this.exprFactory.cond((Expr)this.exprFactory.eq((Object)exprS, (Object)exprTargetURI), (Expr)exprReplacementURI, (Expr)exprS);
        E_Conditional ifP = this.exprFactory.cond((Expr)this.exprFactory.eq((Object)exprP, (Object)exprTargetURI), (Expr)exprReplacementURI, (Expr)exprP);
        E_Conditional ifO = this.exprFactory.cond((Expr)this.exprFactory.eq((Object)exprO, (Object)exprTargetURI), (Expr)exprReplacementURI, (Expr)exprO);
        E_Conditional ifSBlank = this.exprFactory.cond((Expr)this.exprFactory.isBlank((Object)exprS), (Expr)exprS, (Expr)ifS);
        E_Conditional ifPBlank = this.exprFactory.cond((Expr)this.exprFactory.isBlank((Object)exprP), (Expr)exprP, (Expr)ifP);
        E_Conditional ifOBlank = this.exprFactory.cond((Expr)this.exprFactory.isBlank((Object)exprO), (Expr)exprO, (Expr)ifO);
        WhereBuilder where = this.whereMatchIRI().addBind((Expr)ifSBlank, (Object)newS).addBind((Expr)ifPBlank, (Object)newP).addBind((Expr)ifOBlank, (Object)newO);
        return where;
    }

    private WhereBuilder whereMatchString() {
        E_StrContains SContainsMatch = this.exprFactory.contains((Object)this.exprFactory.str((Object)exprS), (Object)this.exprMatch);
        E_StrContains PContainsMatch = this.exprFactory.contains((Object)this.exprFactory.str((Object)exprP), (Object)this.exprMatch);
        E_StrContains OContainsMatch = this.exprFactory.contains((Object)this.exprFactory.str((Object)exprO), (Object)this.exprMatch);
        E_StrContains SContainsTarget = this.exprFactory.contains((Object)this.exprFactory.str((Object)exprS), (Object)this.exprTarget);
        E_StrContains PContainsTarget = this.exprFactory.contains((Object)this.exprFactory.str((Object)exprP), (Object)this.exprTarget);
        E_StrContains OContainsTarget = this.exprFactory.contains((Object)this.exprFactory.str((Object)exprO), (Object)this.exprTarget);
        E_StrContains SContains = SContainsMatch;
        E_StrContains PContains = PContainsMatch;
        E_StrContains OContains = OContainsMatch;
        if (this.exprMatch != this.exprTarget) {
            SContains = this.exprFactory.and((Object)SContainsMatch, (Object)SContainsTarget);
            PContains = this.exprFactory.and((Object)PContainsMatch, (Object)PContainsTarget);
            OContains = this.exprFactory.and((Object)OContainsMatch, (Object)OContainsTarget);
        }
        E_LogicalOr or = this.exprFactory.or((Object)exprMatchS, (Object)this.exprFactory.or((Object)exprMatchP, (Object)exprMatchO));
        WhereBuilder where = new WhereBuilder().addWhere((Object)varS, (Object)varP, (Object)varO);
        if (this.exprFilter != null) {
            where.addFilter(this.exprFilter);
        }
        where.addBind((Expr)SContains, (Object)matchS).addBind((Expr)PContains, (Object)matchP).addBind((Expr)OContains, (Object)matchO).addFilter((Expr)or);
        return where;
    }

    private WhereBuilder whereUpdateString() {
        Expr exprReplacement = this.exprFactory.asExpr((Object)this.strReplacement);
        E_StrReplace replaceS = this.exprFactory.replace((Object)this.exprFactory.str((Object)exprS), (Object)this.exprTarget, (Object)exprReplacement);
        E_StrReplace replaceP = this.exprFactory.replace((Object)this.exprFactory.str((Object)exprP), (Object)this.exprTarget, (Object)exprReplacement);
        E_StrReplace replaceO = this.exprFactory.replace((Object)this.exprFactory.str((Object)exprO), (Object)this.exprTarget, (Object)exprReplacement);
        E_Conditional ifS = this.exprFactory.cond((Expr)exprMatchS, (Expr)this.exprFactory.iri((Object)replaceS), (Expr)exprS);
        E_Conditional ifP = this.exprFactory.cond((Expr)exprMatchP, (Expr)this.exprFactory.iri((Object)replaceP), (Expr)exprP);
        E_Conditional ifO = this.exprFactory.cond((Expr)exprMatchO, (Expr)this.exprFactory.iri((Object)replaceO), (Expr)exprO);
        E_Conditional ifSBlank = this.exprFactory.cond((Expr)this.exprFactory.isBlank((Object)exprS), (Expr)exprS, (Expr)ifS);
        E_Conditional ifPBlank = this.exprFactory.cond((Expr)this.exprFactory.isBlank((Object)exprP), (Expr)exprP, (Expr)ifP);
        E_Conditional ifOBlank = this.exprFactory.cond((Expr)this.exprFactory.isBlank((Object)exprO), (Expr)exprO, (Expr)ifO);
        WhereBuilder where = this.whereMatchString().addBind((Expr)ifSBlank, (Object)newS).addBind((Expr)ifPBlank, (Object)newP).addBind((Expr)ifOBlank, (Object)newO);
        return where;
    }
}

