/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeries;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeriesRDBClient;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeriesSparql;

public class TimeSeriesClient<T> {
    private TimeSeriesRDBClient<T> rdbClient;
    private TimeSeriesSparql rdfClient;
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";

    public TimeSeriesClient(StoreClientInterface kbClient, Class<T> timeClass, String rdbURL, String user, String password) {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.rdbClient.setRdbURL(rdbURL);
        this.rdbClient.setRdbUser(user);
        this.rdbClient.setRdbPassword(password);
    }

    public TimeSeriesClient(StoreClientInterface kbClient, Class<T> timeClass, String filepath) throws IOException {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.loadRdbConfigs(filepath);
    }

    public TimeSeriesClient(Class<T> timeClass, String filepath) throws IOException {
        RemoteStoreClient kbClient = new RemoteStoreClient();
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.loadSparqlConfigs(filepath);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.loadRdbConfigs(filepath);
    }

    private void loadRdbConfigs(String filepath) throws IOException {
        this.rdbClient.loadRdbConfigs(filepath);
    }

    private void loadSparqlConfigs(String filepath) throws IOException {
        this.rdfClient.loadSparqlConfigs(filepath);
    }

    public void setKBClient(StoreClientInterface kbClient) {
        this.rdfClient.setKBClient(kbClient);
    }

    public void setRDBClient(String rdbURL, String user, String password) {
        this.rdbClient.setRdbURL(rdbURL);
        this.rdbClient.setRdbUser(user);
        this.rdbClient.setRdbPassword(password);
    }

    public void initTimeSeries(List<String> dataIRIs, List<Class<?>> dataClass, String timeUnit) {
        String tsIRI = "http://www.theworldavatar.com/kb/ontotimeseries/Timeseries_" + UUID.randomUUID();
        try {
            this.rdfClient.initTS(tsIRI, dataIRIs, this.rdbClient.getRdbURL(), timeUnit);
        }
        catch (Exception e_RdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdfCreate);
        }
        try {
            this.rdbClient.initTimeSeriesTable(dataIRIs, dataClass, tsIRI);
        }
        catch (JPSRuntimeException e_RdbCreate) {
            try {
                this.rdfClient.removeTimeSeries(tsIRI);
            }
            catch (Exception e_RdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + tsIRI + " , as database related instantiation failed but KG triples were created.");
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdbCreate);
        }
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit) {
        int i;
        ArrayList<String> tsIRIs = new ArrayList<String>(dataIRIs.size());
        for (i = 0; i < dataIRIs.size(); ++i) {
            String tsIRI = "http://www.theworldavatar.com/kb/ontotimeseries/Timeseries_" + UUID.randomUUID();
            tsIRIs.add(i, tsIRI);
        }
        try {
            this.rdfClient.bulkInitTS(tsIRIs, dataIRIs, this.rdbClient.getRdbURL(), timeUnit);
        }
        catch (Exception e_RdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdfCreate);
        }
        for (i = 0; i < dataIRIs.size(); ++i) {
            try {
                this.rdbClient.initTimeSeriesTable(dataIRIs.get(i), dataClass.get(i), (String)tsIRIs.get(i));
                continue;
            }
            catch (JPSRuntimeException e_RdbCreate) {
                try {
                    this.rdfClient.removeTimeSeries((String)tsIRIs.get(i));
                }
                catch (Exception e_RdfDelete) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + (String)tsIRIs.get(i) + " , as database related instantiation failed but KG triples were created.");
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdbCreate);
            }
        }
    }

    public void addTimeSeriesData(TimeSeries<T> ts) {
        this.rdbClient.addTimeSeriesData(ts);
    }

    public void deleteTimeSeriesHistory(String dataIRI, T lowerBound, T upperBound) {
        this.rdbClient.deleteRows(dataIRI, lowerBound, upperBound);
    }

    public void deleteIndividualTimeSeries(String dataIRI) {
        String tsIRI = this.rdfClient.getTimeSeries(dataIRI);
        if (tsIRI == null) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " not associated with any timeseries.");
        }
        if (this.rdfClient.getAssociatedData(tsIRI).size() == 1) {
            this.deleteTimeSeries(tsIRI);
        } else {
            try {
                this.rdfClient.removeTimeSeriesAssociation(dataIRI);
            }
            catch (Exception e_RdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", e_RdfDelete);
            }
            try {
                this.rdbClient.deleteTimeSeries(dataIRI);
            }
            catch (JPSRuntimeException e_RdbDelete) {
                try {
                    this.rdfClient.insertTimeSeriesAssociation(dataIRI, tsIRI);
                }
                catch (Exception e_RdfCreate) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series association for " + dataIRI + " , as database related deletion failed but KG triples were deleted.");
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", e_RdbDelete);
            }
        }
    }

    public void deleteTimeSeries(String tsIRI) {
        if (!this.rdfClient.checkTimeSeriesExists(tsIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + tsIRI + " does not exist in KG");
        }
        List<String> dataIRIs = this.rdfClient.getAssociatedData(tsIRI);
        String timeUnit = this.rdfClient.getTimeUnit(tsIRI);
        try {
            this.rdfClient.removeTimeSeries(tsIRI);
        }
        catch (Exception e_RdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", e_RdfDelete);
        }
        try {
            this.rdbClient.deleteTimeSeriesTable(dataIRIs.get(0));
        }
        catch (JPSRuntimeException e_RdbDelete) {
            try {
                this.rdfClient.initTS(tsIRI, dataIRIs, this.rdbClient.getRdbURL(), timeUnit);
            }
            catch (Exception e_RdfCreate) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series " + tsIRI + " , as database related deletion failed but KG triples were deleted.");
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", e_RdbDelete);
        }
    }

    public void deleteAll() {
        try {
            this.rdfClient.removeAllTimeSeries();
        }
        catch (Exception e_RdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from KG! Potentially inconsistent state between KG and database", e_RdfDelete);
        }
        try {
            this.rdbClient.deleteAll();
        }
        catch (JPSRuntimeException e_RdbDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from database! Potentially inconsistent state between KG and database", e_RdbDelete);
        }
    }

    public TimeSeries<T> getLatestData(String dataIRI) {
        return this.rdbClient.getLatestData(dataIRI);
    }

    public TimeSeries<T> getOldestData(String dataIRI) {
        return this.rdbClient.getOldestData(dataIRI);
    }

    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRIs, T lowerBound, T upperBound) {
        return this.rdbClient.getTimeSeriesWithinBounds(dataIRIs, lowerBound, upperBound);
    }

    public TimeSeries<T> getTimeSeries(List<String> dataIRIs) {
        return this.getTimeSeriesWithinBounds(dataIRIs, null, null);
    }

    public double getAverage(String dataIRI) {
        return this.rdbClient.getAverage(dataIRI);
    }

    public double getMaxValue(String dataIRI) {
        return this.rdbClient.getMaxValue(dataIRI);
    }

    public double getMinValue(String dataIRI) {
        return this.rdbClient.getMinValue(dataIRI);
    }

    public T getMaxTime(String dataIRI) {
        return this.rdbClient.getMaxTime(dataIRI);
    }

    public T getMinTime(String dataIRI) {
        return this.rdbClient.getMinTime(dataIRI);
    }

    public boolean checkTimeSeriesExists(String tsIRI) {
        return this.rdfClient.checkTimeSeriesExists(tsIRI);
    }

    public boolean checkDataHasTimeSeries(String dataIRI) {
        return this.rdbClient.checkDataHasTimeSeries(dataIRI);
    }

    public boolean checkTimeUnitExists(String tsIRI) {
        return this.rdfClient.checkTimeUnitExists(tsIRI);
    }

    public int countTimeSeries() {
        return this.rdfClient.countTS();
    }

    public String getTimeSeriesIRI(String dataIRI) {
        return this.rdfClient.getTimeSeries(dataIRI);
    }

    public String getDbUrl(String tsIRI) {
        return this.rdfClient.getDbUrl(tsIRI);
    }

    public String getTimeUnit(String tsIRI) {
        return this.rdfClient.getTimeUnit(tsIRI);
    }

    public List<String> getAssociatedData(String tsIRI) {
        return this.rdfClient.getAssociatedData(tsIRI);
    }

    public List<String> getAllTimeSeries() {
        return this.rdfClient.getAllTimeSeries();
    }

    public void disconnectRDB() {
        this.rdbClient.disconnect();
    }

    public JSONArray convertToJSON(List<TimeSeries<T>> ts_list, List<Integer> id, List<Map<String, String>> units_map, List<Map<String, String>> table_header_map) {
        JSONArray ts_array = new JSONArray();
        for (int i = 0; i < ts_list.size(); ++i) {
            TimeSeries<T> ts = ts_list.get(i);
            JSONObject ts_jo = new JSONObject();
            List<String> dataIRIs = ts.getDataIRIs();
            ts_jo.put("id", (Object)id.get(i));
            if (ts.getTimes().size() > 0) {
                if (ts.getTimes().get(0) instanceof Number) {
                    ts_jo.put("timeClass", (Object)Number.class.getSimpleName());
                } else {
                    ts_jo.put("timeClass", (Object)ts.getTimes().get(0).getClass().getSimpleName());
                }
            }
            if (table_header_map != null) {
                ArrayList<String> table_header = new ArrayList<String>();
                for (String dataIRI : dataIRIs) {
                    table_header.add(table_header_map.get(i).get(dataIRI));
                }
                ts_jo.put("data", table_header);
            } else {
                ts_jo.put("data", dataIRIs);
            }
            ArrayList<String> units = new ArrayList<String>();
            for (String dataIRI : dataIRIs) {
                units.add(units_map.get(i).get(dataIRI));
            }
            ts_jo.put("units", units);
            ts_jo.put("time", ts.getTimes());
            JSONArray values = new JSONArray();
            JSONArray valuesClass = new JSONArray();
            for (int j = 0; j < dataIRIs.size(); ++j) {
                List<?> valueslist = ts.getValues(dataIRIs.get(j));
                values.put(valueslist);
                if (valueslist.size() <= 0) continue;
                if (valueslist.get(0) instanceof Number) {
                    valuesClass.put((Object)Number.class.getSimpleName());
                    continue;
                }
                valuesClass.put((Object)valueslist.get(0).getClass().getSimpleName());
            }
            ts_jo.put("values", (Object)values);
            ts_jo.put("valuesClass", (Object)valuesClass);
            ts_array.put((Object)ts_jo);
        }
        return ts_array;
    }
}

