/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.arq.querybuilder.ConstructBuilder;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.update.UpdateRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class FileBasedStoreClient
implements StoreClientInterface {
    private static Logger LOGGER = LogManager.getLogger(FileBasedStoreClient.class);
    private Dataset dataset;
    private RDFConnection conn;
    private String query;
    private ArrayList<GraphData> namedGraphs = new ArrayList();
    private GraphData defaultGraph = new GraphData();
    private boolean autoWrite = true;

    public FileBasedStoreClient() {
        this.init();
    }

    public FileBasedStoreClient(String filePath) {
        this.init();
        this.load(filePath);
    }

    public FileBasedStoreClient(String graph, String filePath) {
        this.init();
        this.load(graph, filePath);
    }

    private void init() {
        this.dataset = DatasetFactory.create();
        this.conn = RDFConnectionFactory.connect((Dataset)this.dataset);
    }

    public void load() {
        if (this.namedGraphs.size() > 0) {
            for (int i = 0; i < this.namedGraphs.size(); ++i) {
                this.loadGraph(this.namedGraphs.get(i));
            }
        }
        if (this.defaultGraph.path != null) {
            this.loadGraph(this.defaultGraph);
        }
    }

    public void load(String filePath) {
        this.load(null, filePath);
    }

    public void load(String graphName, String filePath) {
        GraphData graph = new GraphData(graphName, filePath);
        File f = new File(graph.path);
        if (f.exists()) {
            this.loadGraph(graph);
        } else {
            Lang lang;
            graph.lang = lang = RDFLanguages.filenameToLang((String)graph.path);
            LOGGER.info(filePath + " does not exist. Creating empty FileBasedStoreClient. File language set to: " + lang);
        }
        if (graph != null) {
            if (graph.name == null) {
                this.defaultGraph = graph;
            } else {
                this.namedGraphs.add(graph);
            }
        }
    }

    public void load(String[] names, String[] filePaths) {
        if (names.length == filePaths.length) {
            for (int i = 0; i < names.length; ++i) {
                this.load(names[i], filePaths[i]);
            }
        } else {
            throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: file path or graph name missing (graphs.length != flePaths.length).");
        }
    }

    private void loadGraph(GraphData graph) {
        File f;
        if (!this.isConnected()) {
            this.init();
        }
        if ((f = new File(graph.path)).exists()) {
            Lang lang = RDFLanguages.filenameToLang((String)graph.path);
            System.out.println("FileBasedKnowledgeBaseClient: File language is: " + lang);
            graph.lang = lang;
            if (RDFLanguages.isTriples((Lang)lang)) {
                if (graph.name == null) {
                    if (!this.dataset.getDefaultModel().isEmpty()) {
                        throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: default graph already exists!");
                    }
                } else if (this.dataset.containsNamedModel(graph.name)) {
                    throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: " + graph.name + " already exists!");
                }
                this.conn.load(graph.name, graph.path);
            } else {
                Dataset tempDataset = RDFDataMgr.loadDataset((String)graph.path);
                Iterator it = tempDataset.listNames();
                int contextCount = 0;
                while (it.hasNext()) {
                    if (++contextCount > 1) {
                        throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: multiple contexts in file not supported!");
                    }
                    String context = (String)it.next();
                    if (context == null) {
                        if (!this.dataset.getDefaultModel().isEmpty()) {
                            throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: default graph already exists!");
                        }
                    } else if (this.dataset.containsNamedModel(context)) {
                        throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: " + context + " already exists!");
                    }
                    if (context.equals(graph.name)) continue;
                    System.out.println("FileBasedKnowledgeBaseClient: graph name " + graph.name + " changed to " + context);
                    graph.name = context;
                }
                this.conn.loadDataset(tempDataset);
                tempDataset.asDatasetGraph().clear();
                tempDataset.close();
            }
        } else {
            throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: cannot load " + graph.path + ". File does not exist.");
        }
    }

    public void end() {
        this.writeToFile();
        this.conn.close();
        this.dataset.close();
    }

    public void writeToFile() {
        if (this.namedGraphs.size() > 0) {
            for (int i = 0; i < this.namedGraphs.size(); ++i) {
                this.writeToFile(this.namedGraphs.get(i));
            }
        }
        if (this.defaultGraph.path != null) {
            this.writeToFile(this.defaultGraph);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeToFile(String graphName) {
        if (graphName == null || graphName.equals("default")) {
            if (this.defaultGraph.path == null && this.defaultGraph.lang == null) throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: no file path.");
            this.writeToFile(this.defaultGraph);
            return;
        } else {
            GraphData graph = this.getGraph(graphName);
            if (graph == null) throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: graph not found.");
            this.writeToFile(graph);
        }
    }

    public void writeToFile(String filePath, Lang langOut) {
        this.writeToFile(null, filePath, langOut);
    }

    private void writeToFile(GraphData graph) {
        this.writeToFile(graph.name, graph.path, graph.lang);
    }

    public void writeToFile(String name, String filePath, Lang langOut) {
        block18: {
            LOGGER.debug("Writing to file");
            try (FileOutputStream out = new FileOutputStream(filePath);){
                if (name == null || name.equals("default")) {
                    RDFDataMgr.write((OutputStream)out, (Model)this.dataset.getDefaultModel(), (Lang)langOut);
                    out.flush();
                    LOGGER.info("Default graph written to: " + filePath + ". Lang: " + langOut.getName());
                    break block18;
                }
                if (this.dataset.containsNamedModel(name)) {
                    if (RDFLanguages.isTriples((Lang)langOut)) {
                        RDFDataMgr.write((OutputStream)out, (Model)this.dataset.getNamedModel(name), (Lang)langOut);
                    } else {
                        Dataset datasetOut = DatasetFactory.create();
                        datasetOut.addNamedModel(name, this.dataset.getNamedModel(name));
                        RDFDataMgr.write((OutputStream)out, (Dataset)datasetOut, (Lang)langOut);
                    }
                    out.flush();
                    LOGGER.info("Named graph" + name + " written to: " + filePath + ". Lang: " + langOut.getName());
                    break block18;
                }
                throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: " + name + " does not exist.");
            }
            catch (IOException e) {
                throw new JPSRuntimeException(e);
            }
        }
    }

    @Override
    public String getUser() {
        return null;
    }

    @Override
    public void setUser(String userName) {
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public void setPassword(String password) {
    }

    private GraphData getGraph(String name) {
        if (name == null || name.equals("default")) {
            return this.defaultGraph;
        }
        for (int i = 0; i < this.namedGraphs.size(); ++i) {
            if (!this.namedGraphs.get((int)i).name.equals(name)) continue;
            return this.namedGraphs.get(i);
        }
        return null;
    }

    public boolean containsGraph(String name) {
        GraphData graph = this.getGraph(name);
        if (graph != null) {
            return this.dataset.containsNamedModel(name);
        }
        return false;
    }

    public List<String> getGraphNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.namedGraphs.size(); ++i) {
            names.add(this.namedGraphs.get((int)i).name);
        }
        return names;
    }

    public Lang getLang(String name) {
        GraphData graph = this.getGraph(name);
        return graph.lang;
    }

    public String getPath(String name) {
        GraphData graph = this.getGraph(name);
        return graph.path;
    }

    public void setAutoWrite(boolean value) {
        this.autoWrite = value;
    }

    public void setOutputLang(Lang langOut) {
        this.defaultGraph.lang = langOut;
    }

    public void setOutputLang(String name, Lang langOut) {
        GraphData graph = this.getGraph(name);
        if (graph != null) {
            graph.lang = langOut;
        }
    }

    @Override
    public String setQuery(String query) {
        this.query = query;
        return this.query;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public void setPath(String filePath) {
        this.setPath(null, filePath);
    }

    public void setPath(String name, String filePath) {
        GraphData graph = this.getGraph(name);
        if (graph != null) {
            graph.path = filePath;
        }
    }

    @Override
    public String setUpdateEndpoint(String updateEndpoint) {
        this.defaultGraph.path = updateEndpoint;
        return this.defaultGraph.path;
    }

    @Override
    public String getUpdateEndpoint() {
        return this.defaultGraph.path;
    }

    @Override
    public String setQueryEndpoint(String queryEndpoint) {
        this.defaultGraph.path = queryEndpoint;
        return this.defaultGraph.path;
    }

    @Override
    public String getQueryEndpoint() {
        return this.getUpdateEndpoint();
    }

    public boolean isConnected() {
        return !this.conn.isClosed();
    }

    public boolean isEmpty() {
        if (!this.isConnected()) {
            return true;
        }
        return this.dataset.isEmpty();
    }

    @Override
    public int executeUpdate() {
        return this.executeUpdate(this.query);
    }

    @Override
    public int executeUpdate(String update) {
        LOGGER.debug("Performing SPARQL UPDATE.");
        if (this.isEmpty()) {
            this.load();
        }
        if (this.conn != null) {
            this.conn.begin(TxnType.WRITE);
            try {
                this.conn.update(update);
                this.conn.commit();
            }
            finally {
                this.conn.end();
            }
            if (this.autoWrite) {
                this.writeToFile();
            }
            return 0;
        }
        throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: client not initialised.");
    }

    @Override
    public int executeUpdate(UpdateRequest update) {
        LOGGER.debug("Performing SPARQL UPDATE.");
        if (this.conn != null) {
            this.conn.begin(TxnType.WRITE);
            try {
                this.conn.update(update);
                this.conn.commit();
            }
            finally {
                this.conn.end();
            }
            if (this.autoWrite) {
                this.writeToFile();
            }
            return 0;
        }
        throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: client not initialised.");
    }

    @Override
    public String execute() {
        return this.execute(this.query);
    }

    @Override
    public String execute(String query) {
        JSONArray result = this.executeQuery(query);
        if (result == null) {
            throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: sparql query result is null.");
        }
        return result.toString();
    }

    @Override
    public JSONArray executeQuery(String sparql) {
        ResultSet results = this.performExecuteQuery(sparql);
        return this.convert(results);
    }

    @Override
    public JSONArray executeQuery() {
        return this.executeQuery(this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet performExecuteQuery(String sparql) {
        LOGGER.debug("Performing SPARQL QUERY.");
        if (this.isEmpty()) {
            this.load();
        }
        if (this.conn != null) {
            this.conn.begin(TxnType.READ);
            try {
                ResultSet results;
                QueryExecution queryExec = this.conn.query(sparql);
                ResultSet resultSet = results = queryExec.execSelect();
                return resultSet;
            }
            finally {
                this.conn.end();
            }
        }
        throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: client not initialised.");
    }

    private JSONArray convert(ResultSet resultSet) {
        JSONArray json = new JSONArray();
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            JSONObject obj = new JSONObject();
            Iterator it = qs.varNames();
            while (it.hasNext()) {
                String var = (String)it.next();
                RDFNode node = qs.get(var);
                if (node.isLiteral()) {
                    obj.put(var, node.asLiteral().getValue());
                    continue;
                }
                obj.put(var, (Object)node);
            }
            json.put((Object)obj);
        }
        return json;
    }

    @Override
    public Model executeConstruct(Query sparql) {
        return this.executeConstruct(sparql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model executeConstruct(String sparql) {
        if (this.isEmpty()) {
            this.load();
        }
        if (this.conn != null) {
            this.conn.begin(TxnType.READ);
            try {
                Model results;
                QueryExecution queryExec = this.conn.query(sparql);
                Model model = results = queryExec.execConstruct();
                return model;
            }
            finally {
                this.conn.end();
            }
        }
        throw new JPSRuntimeException("FileBasedKnowledgeBaseClient: client not initialised.");
    }

    @Override
    public String get(String resourceUrl, String accept) {
        LOGGER.debug("Performing GET (CONSTRUCT) from graph=" + resourceUrl + ", accept=" + accept);
        Var varS = Var.alloc((String)"s");
        Var varP = Var.alloc((String)"p");
        Var varO = Var.alloc((String)"o");
        ConstructBuilder builder = new ConstructBuilder().addConstruct((Object)varS, (Object)varP, (Object)varO);
        if (resourceUrl == null) {
            builder.addWhere((Object)varS, (Object)varP, (Object)varO);
        } else {
            String graphURI = "<" + resourceUrl + ">";
            builder.addGraph((Object)graphURI, (Object)varS, (Object)varP, (Object)varO);
        }
        Model model = this.executeConstruct(builder.build());
        Lang syntax = accept != null ? RDFLanguages.contentTypeToLang((String)accept) : Lang.RDFXML;
        StringWriter out = new StringWriter();
        model.write((Writer)out, syntax.getName());
        return out.toString();
    }

    @Override
    public void insert(String graphName, String content, String contentType) {
        LOGGER.debug("Performing INSERT to graph=" + graphName + ", contentType=" + contentType);
        Model model = ModelFactory.createDefaultModel();
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        if (contentType == null) {
            LOGGER.info("Assuming default content type RDF/XML");
            model.read((InputStream)in, null);
        } else {
            Lang syntax = RDFLanguages.contentTypeToLang((String)contentType);
            LOGGER.debug("Content type: " + syntax.getName());
            model.read((InputStream)in, null, syntax.getName());
        }
        UpdateBuilder builder = new UpdateBuilder();
        if (graphName == null) {
            LOGGER.debug("Create insert for default graph");
            builder.addInsert(model);
        } else {
            LOGGER.debug("Create insert for namde graph: " + graphName);
            String graphURI = "<" + graphName + ">";
            builder.addInsert((Object)graphURI, model);
        }
        this.executeUpdate(builder.buildRequest());
    }

    class GraphData {
        String name = null;
        String path = null;
        Lang lang = Lang.RDFXML;

        GraphData() {
        }

        GraphData(String name, String filePath) {
            this.name = name;
            this.path = filePath;
        }
    }
}

