/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.derivation.Derivation;
import uk.ac.cam.cares.jps.base.derivation.DerivationSparql;
import uk.ac.cam.cares.jps.base.derivation.Entity;
import uk.ac.cam.cares.jps.base.derivation.StatusType;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class DerivationClient {
    public static final String AGENT_INPUT_KEY = "agent_input";
    public static final String AGENT_OUTPUT_KEY = "agent_output";
    public static final String BELONGSTO_KEY = "belongsTo";
    StoreClientInterface kbClient;
    DerivationSparql sparqlClient;
    boolean upstreamDerivationPendingUpdate;
    private static final Logger LOGGER = LogManager.getLogger(DerivationClient.class);

    @Deprecated
    public DerivationClient(StoreClientInterface kbClient) {
        this.kbClient = kbClient;
        this.sparqlClient = new DerivationSparql(kbClient);
    }

    public DerivationClient(StoreClientInterface kbClient, String derivationInstanceBaseURL) {
        this.kbClient = kbClient;
        this.sparqlClient = new DerivationSparql(kbClient, derivationInstanceBaseURL);
    }

    public String createDerivation(List<String> entities, String agentIRI, String agentURL, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivation(entities, agentIRI, agentURL, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated derivation <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + "> located at " + agentURL);
        return createdDerivation;
    }

    public List<String> bulkCreateDerivations(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList) {
        List<String> derivations = this.sparqlClient.bulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList);
        LOGGER.info("Instantiated derivations " + derivations);
        this.sparqlClient.addTimeInstance(derivations);
        return derivations;
    }

    public String createDerivation(List<String> entities, String agentIRI, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivation(entities, agentIRI, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated derivation for asynchronous operation <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + ">");
        return createdDerivation;
    }

    public String createDerivationWithTimeSeries(List<String> entities, String agentIRI, String agentURL, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivationWithTimeSeries(entities, agentIRI, agentURL, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated derivation with time series <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + "> located at " + agentURL);
        return createdDerivation;
    }

    public List<String> bulkCreateDerivationsWithTimeSeries(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList) {
        List<String> derivations = this.sparqlClient.bulkCreateDerivationsWithTimeSeries(entitiesList, agentIRIList, agentURLList, inputsList);
        LOGGER.info("Instantiated derivations with time series " + derivations);
        this.sparqlClient.addTimeInstance(derivations);
        return derivations;
    }

    public String createAsynDerivation(List<String> entities, String agentIRI, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivationAsyn(entities, agentIRI, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated asynchronous derivation <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + ">");
        return createdDerivation;
    }

    public void addTimeInstance(String entity) {
        this.sparqlClient.addTimeInstance(entity);
        LOGGER.info("Added timestamp to <" + entity + ">");
    }

    public void addTimeInstance(List<String> entities) {
        this.sparqlClient.addTimeInstance(entities);
        LOGGER.info("Added timestamps to <" + entities + ">");
    }

    public void updateTimestamps(List<String> entities) {
        Map<String, String> entityDerivationMap = this.sparqlClient.getDerivationsOf(entities);
        HashMap<String, Long> timestamp_map = new HashMap<String, Long>();
        long currentTime = Instant.now().getEpochSecond();
        for (String entity : entities) {
            if (entityDerivationMap.containsKey(entity)) {
                timestamp_map.put(entityDerivationMap.get(entity), currentTime);
                continue;
            }
            timestamp_map.put(entity, currentTime);
        }
        this.sparqlClient.updateTimestamps(timestamp_map);
    }

    public void updateTimestamp(String entity) {
        this.updateTimestamps(Arrays.asList(entity));
    }

    public void updateDerivationAsyn(String derivationIRI) {
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        try {
            this.upstreamDerivationPendingUpdate = false;
            this.updateDerivationAsyn(derivationIRI, (DirectedAcyclicGraph<String, DefaultEdge>)graph);
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public void updateDerivations(List<String> derivedIRIs) {
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        List<Derivation> derivations = this.sparqlClient.getDerivations();
        try {
            for (String derivedIRI : derivedIRIs) {
                Derivation derivation = derivations.stream().filter(d -> d.getIri().equals(derivedIRI)).findFirst().get();
                this.updateDerivation(derivation, (DirectedAcyclicGraph<String, DefaultEdge>)graph);
            }
            HashMap<String, Long> derivationTime_map = new HashMap<String, Long>();
            for (Derivation derivation : derivations) {
                if (!derivation.getUpdateStatus()) continue;
                derivationTime_map.put(derivation.getIri(), derivation.getTimestamp());
            }
            this.sparqlClient.updateTimestamps(derivationTime_map);
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public void updateDerivations() {
        List<Derivation> derivations = this.sparqlClient.getDerivations();
        ArrayList<Derivation> topNodes = new ArrayList<Derivation>();
        for (Derivation derivation : derivations) {
            if (!derivation.getEntities().stream().allMatch(e -> !e.isInputToDerivation())) continue;
            topNodes.add(derivation);
        }
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        try {
            for (Derivation derivation : topNodes) {
                this.updateDerivation(derivation, (DirectedAcyclicGraph<String, DefaultEdge>)graph);
            }
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (Derivation derivation : derivations) {
                if (!derivation.getUpdateStatus()) continue;
                hashMap.put(derivation.getIri(), derivation.getTimestamp());
            }
            this.sparqlClient.updateTimestamps(hashMap);
        }
        catch (Exception exception) {
            LOGGER.fatal(exception.getMessage());
            throw new JPSRuntimeException(exception);
        }
    }

    public boolean validateDerivations() {
        if (!this.sparqlClient.validatePureInputs()) {
            throw new JPSRuntimeException("Entities belonging to a derivation should not have timestamps attached");
        }
        List<Derivation> derivations = this.sparqlClient.getDerivations();
        ArrayList<Derivation> topNodes = new ArrayList<Derivation>();
        for (Derivation derivation : derivations) {
            if (!derivation.getEntities().stream().allMatch(e -> !e.isInputToDerivation())) continue;
            topNodes.add(derivation);
        }
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        try {
            for (Derivation derivation : topNodes) {
                this.validateDerivation(derivation, (DirectedAcyclicGraph<String, DefaultEdge>)graph);
            }
        }
        catch (Exception exception) {
            LOGGER.fatal(exception.getMessage());
            throw new JPSRuntimeException(exception);
        }
        return true;
    }

    public JSONObject retrieveAgentInputIRIs(String derivation, String agentIRI) {
        JSONObject agentInputs = new JSONObject();
        agentInputs.put(AGENT_INPUT_KEY, (Object)this.sparqlClient.getInputsMapToAgent(derivation, agentIRI));
        this.sparqlClient.updateStatusBeforeSetupJob(derivation);
        return agentInputs;
    }

    public void dropAllDerivationsAndTimestamps() {
        this.dropAllDerivations();
        this.dropAllTimestamps();
    }

    public void dropAllDerivations() {
        this.sparqlClient.dropAllDerivations();
        LOGGER.info("Dropped all derivations");
    }

    public void dropAllTimestamps() {
        this.sparqlClient.dropAllTimestamps();
        LOGGER.info("Dropped all timestamps");
    }

    public void updateStatusAtJobCompletion(String derivation, List<String> newDerivedIRI) {
        this.sparqlClient.updateStatusAtJobCompletion(derivation, newDerivedIRI);
    }

    public List<String> checkAtPendingUpdate(String derivation) {
        List<String> upstreamDerivationsNeedUpdate = this.sparqlClient.getUpstreamDerivationsNeedUpdate(derivation);
        if (upstreamDerivationsNeedUpdate.isEmpty()) {
            this.sparqlClient.markAsRequested(derivation);
        }
        return upstreamDerivationsNeedUpdate;
    }

    public void cleanUpFinishedDerivationUpdate(String derivation) {
        List<String> newEntitiesString = this.sparqlClient.getNewDerivedIRI(derivation);
        List<Entity> oldEntitiesAsInput = this.sparqlClient.getDerivedEntitiesAndDownstreamDerivation(derivation);
        this.sparqlClient.deleteBelongsTo(derivation);
        LOGGER.debug("Deleted old instances of derivation: " + derivation);
        this.sparqlClient.addNewEntitiesToDerived(derivation, newEntitiesString);
        LOGGER.debug("Added new instances <" + newEntitiesString + "> to the derivation <" + derivation + ">");
        List<Entity> newEntities = this.sparqlClient.initialiseNewEntities(newEntitiesString);
        if (oldEntitiesAsInput.size() > 0) {
            LOGGER.debug("This derivation contains at least one entity which is an input to another derivation");
            LOGGER.debug("Relinking new instance(s) to the derivation by matching their rdf:type");
            ArrayList<String> newInputs = new ArrayList<String>();
            ArrayList<String> derivationsToReconnect = new ArrayList<String>();
            for (Entity oldInput : oldEntitiesAsInput) {
                List matchingEntity = newEntities.stream().filter(e -> e.getRdfType().equals(oldInput.getRdfType())).collect(Collectors.toList());
                if (matchingEntity.size() != 1) {
                    String errmsg = "When the agent writes new instances, make sure that there is 1 instance with matching rdf:type over the old set";
                    LOGGER.error(errmsg);
                    LOGGER.error("Number of matching entities = " + matchingEntity.size());
                    throw new JPSRuntimeException(errmsg);
                }
                newInputs.add(((Entity)matchingEntity.get(0)).getIri());
                derivationsToReconnect.add(oldInput.getInputOf().getIri());
            }
            this.sparqlClient.reconnectInputToDerived(newInputs, derivationsToReconnect);
        }
        this.sparqlClient.deleteStatus(derivation);
        Map<String, Long> derivationTime_map = this.sparqlClient.retrieveInputReadTimestamp(derivation);
        this.sparqlClient.updateTimestamps(derivationTime_map);
        LOGGER.info("Updated timestamp of <" + derivation + ">");
    }

    public boolean isDerivedAsynchronous(String derivation) {
        return this.sparqlClient.isDerivedAsynchronous(derivation);
    }

    public StatusType getStatusType(String derivation) {
        return this.sparqlClient.getStatusType(derivation);
    }

    public List<String> getNewDerivedIRI(String derivation) {
        return this.sparqlClient.getNewDerivedIRI(derivation);
    }

    public String getAgentUrl(String derivedQuantity) {
        return this.sparqlClient.getAgentUrl(derivedQuantity);
    }

    public List<String> getDerivations(String agentIRI) {
        return this.sparqlClient.getDerivations(agentIRI);
    }

    public Map<String, StatusType> getDerivationsAndStatusType(String agentIRI) {
        return this.sparqlClient.getDerivationsAndStatusType(agentIRI);
    }

    public Map<String, String> getDerivationsOf(List<String> entities) {
        return this.sparqlClient.getDerivationsOf(entities);
    }

    private void updateDerivationAsyn(String instance, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<String> inputsAndDerived = this.sparqlClient.getInputsAndDerived(instance);
        if (!graph.containsVertex((Object)instance)) {
            graph.addVertex((Object)instance);
        }
        for (String input : inputsAndDerived) {
            if (!graph.addVertex((Object)input) || null == graph.addEdge((Object)instance, (Object)input)) continue;
            this.updateDerivationAsyn(input, graph);
        }
        List<String> inputs = this.sparqlClient.getInputs(instance);
        if (inputs.size() > 0 && this.isDerivedAsynchronous(instance)) {
            if (this.isOutOfDate(instance, inputs)) {
                if (!this.sparqlClient.hasStatus(instance)) {
                    this.sparqlClient.markAsPendingUpdate(instance);
                }
                this.upstreamDerivationPendingUpdate = true;
            } else if (this.upstreamDerivationPendingUpdate && !this.sparqlClient.hasStatus(instance)) {
                this.sparqlClient.markAsPendingUpdate(instance);
            }
        }
    }

    private void updateDerivation(Derivation derivation, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<Derivation> inputsWithBelongsTo = derivation.getInputsWithBelongsTo();
        if (!graph.containsVertex((Object)derivation.getIri())) {
            graph.addVertex((Object)derivation.getIri());
        }
        for (Derivation input : inputsWithBelongsTo) {
            if (!graph.containsVertex((Object)input.getIri())) {
                graph.addVertex((Object)input.getIri());
            }
            if (null == graph.addEdge((Object)derivation.getIri(), (Object)input.getIri())) continue;
            this.updateDerivation(input, graph);
        }
        List<String> inputs = derivation.getAgentInputs();
        if (inputs.size() > 0 && derivation.isOutOfDate()) {
            LOGGER.info("Updating <" + derivation.getIri() + ">");
            String agentURL = derivation.getAgentURL();
            JSONObject requestParams = new JSONObject();
            JSONArray iris = new JSONArray(inputs);
            requestParams.put(AGENT_INPUT_KEY, (Object)iris);
            requestParams.put(BELONGSTO_KEY, derivation.getEntitiesIri());
            LOGGER.debug("Updating <" + derivation.getIri() + "> using agent at <" + agentURL + "> with http request " + requestParams);
            long newTimestamp = Instant.now().getEpochSecond();
            String response = AgentCaller.executeGetWithURLAndJSON(agentURL, requestParams.toString());
            LOGGER.debug("Obtained http response from agent: " + response);
            if (!derivation.isDerivationWithTimeSeries()) {
                List<String> newEntitiesString = new JSONObject(response).getJSONArray(AGENT_OUTPUT_KEY).toList().stream().map(iri -> (String)iri).collect(Collectors.toList());
                this.sparqlClient.deleteBelongsTo(derivation.getIri());
                LOGGER.debug("Deleted old instances of: " + derivation.getIri());
                this.sparqlClient.addNewEntitiesToDerived(derivation.getIri(), newEntitiesString);
                LOGGER.debug("Added new instances <" + newEntitiesString + "> to the derivation <" + derivation.getIri() + ">");
                List inputToAnotherDerivation = derivation.getEntities().stream().filter(e -> e.isInputToDerivation()).collect(Collectors.toList());
                List<Entity> newEntities = this.sparqlClient.initialiseNewEntities(newEntitiesString);
                if (inputToAnotherDerivation.size() > 0) {
                    LOGGER.debug("This derivation contains at least one entity which is an input to another derivation");
                    LOGGER.debug("Relinking new instance(s) to the derivation by matching their rdf:type");
                    ArrayList<String> newInputs = new ArrayList<String>();
                    ArrayList<String> derivationsToReconnect = new ArrayList<String>();
                    for (Entity oldInput : inputToAnotherDerivation) {
                        List matchingEntity = newEntities.stream().filter(e -> e.getRdfType().equals(oldInput.getRdfType())).collect(Collectors.toList());
                        if (matchingEntity.size() != 1) {
                            String errmsg = "When the agent writes new instances, make sure that there is 1 instance with matching rdf:type over the old set";
                            LOGGER.error(errmsg);
                            LOGGER.error("Number of matching entities = " + matchingEntity.size());
                            throw new JPSRuntimeException(errmsg);
                        }
                        Derivation derivationToReconnect = oldInput.getInputOf();
                        derivationToReconnect.addInput((Entity)matchingEntity.get(0));
                        derivationToReconnect.removeInput(oldInput);
                        newInputs.add(((Entity)matchingEntity.get(0)).getIri());
                        derivationsToReconnect.add(derivationToReconnect.getIri());
                    }
                    this.sparqlClient.reconnectInputToDerived(newInputs, derivationsToReconnect);
                    derivation.replaceEntities(newEntities);
                }
            }
            derivation.setTimestamp(newTimestamp);
            derivation.setUpdateStatus(true);
        }
    }

    private void validateDerivation(Derivation derivation, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<Derivation> inputsWithBelongsTo = derivation.getInputsWithBelongsTo();
        if (!graph.containsVertex((Object)derivation.getIri())) {
            graph.addVertex((Object)derivation.getIri());
        }
        for (Derivation input : inputsWithBelongsTo) {
            if (!graph.containsVertex((Object)input.getIri())) {
                graph.addVertex((Object)input.getIri());
            }
            if (null == graph.addEdge((Object)derivation.getIri(), (Object)input.getIri())) continue;
            this.validateDerivation(input, graph);
        }
        List<Entity> inputs = derivation.getInputs();
        for (Entity input : inputs) {
            if (input.hasBelongsTo() || input.getTimestamp() != null) continue;
            throw new JPSRuntimeException(input.getIri() + " does not have a timestamp");
        }
    }

    private boolean isOutOfDate(String instance, List<String> inputs) {
        boolean outOfDate = false;
        long instanceTimestamp = this.sparqlClient.getTimestamp(instance);
        for (String input : inputs) {
            long inputTimestamp = this.sparqlClient.getTimestamp(input);
            if (inputTimestamp <= instanceTimestamp) continue;
            outOfDate = true;
            return outOfDate;
        }
        return outOfDate;
    }
}

