/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.agent;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.agent.JPSAgent;
import uk.ac.cam.cares.jps.base.derivation.DerivationClient;
import uk.ac.cam.cares.jps.base.derivation.StatusType;
import uk.ac.cam.cares.jps.base.interfaces.AsynAgentInterface;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class AsynAgent
extends JPSAgent
implements AsynAgentInterface {
    private static final Logger LOGGER = LogManager.getLogger(AsynAgent.class);
    private static final long serialVersionUID = 1L;
    static final String msg = "This agent is an instance of AsynAgent, which monitors the derivation and should NOT be used as an HTTP servlet.";
    StoreClientInterface storeClient;
    DerivationClient devClient;

    public AsynAgent() {
        LOGGER.info("A new AsynAgent has been initialised.");
    }

    public AsynAgent(StoreClientInterface storeClient, String derivationInstanceBaseURL) {
        this.storeClient = storeClient;
        this.devClient = new DerivationClient(storeClient, derivationInstanceBaseURL);
    }

    @Override
    public JSONObject processRequestParameters(JSONObject requestParams) {
        JSONObject response = new JSONObject();
        response.put("status", (Object)msg);
        return response;
    }

    @Override
    public void monitorDerivation(String agentIRI) {
        Map<String, StatusType> derivationsAndStatusType = this.devClient.getDerivationsAndStatusType(agentIRI);
        if (derivationsAndStatusType.isEmpty()) {
            LOGGER.info("Currently, no derivation <isDerivedUsing> <" + agentIRI + ">.");
        } else {
            LOGGER.info("A list of derivations that <isDerivedUsing> <" + agentIRI + "> are retrieved: " + derivationsAndStatusType.toString() + ".");
        }
        derivationsAndStatusType.forEach((derivation, statusType) -> {
            LOGGER.info("Derivation <" + derivation + "> has status type: " + (Object)statusType + ".");
            switch (statusType) {
                case PENDINGUPDATE: {
                    List<String> immediateUpstreamDerivationToUpdate = this.devClient.checkAtPendingUpdate((String)derivation);
                    LOGGER.info("Derivation <" + derivation + "> has a list of immediate upstream derivations to be updated: " + immediateUpstreamDerivationToUpdate.toString());
                    break;
                }
                case REQUESTED: {
                    JSONObject agentInputs = this.devClient.retrieveAgentInputIRIs((String)derivation, agentIRI);
                    LOGGER.info("Agent <" + agentIRI + "> retrieved inputs of derivation <" + derivation + ">: " + agentInputs.toString() + ".");
                    LOGGER.info("Derivation <" + derivation + "> is now in progress.");
                    List<String> newDerivedIRI = this.setupJob(agentInputs);
                    LOGGER.info("Derivation <" + derivation + "> has new generated derived IRI: " + newDerivedIRI.toString() + ".");
                    this.devClient.updateStatusAtJobCompletion((String)derivation, newDerivedIRI);
                    LOGGER.info("Derivation <" + derivation + "> is now finished, to be cleaned up.");
                    break;
                }
                case INPROGRESS: {
                    break;
                }
                case FINISHED: {
                    this.devClient.cleanUpFinishedDerivationUpdate((String)derivation);
                    LOGGER.info("Derivation <" + derivation + "> is now cleand up.");
                    break;
                }
            }
        });
    }

    @Override
    public List<String> setupJob(JSONObject requestParams) {
        return null;
    }
}

