/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collection;
import java.util.stream.Stream;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.HasIndividualsInSignature;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class ConvertPropertyAssertionsToAnnotations
extends AbstractCompositeOntologyChange {
    private final Collection<OWLOntology> ontologies;

    public ConvertPropertyAssertionsToAnnotations(OWLDataFactory dataFactory, Collection<OWLOntology> ontologies) {
        super(dataFactory);
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        this.generateChanges();
    }

    private Stream<OWLOntology> ontologies() {
        return this.ontologies.stream();
    }

    private Collection<OWLNamedIndividual> getPunnedIndividuals(Stream<OWLNamedIndividual> individuals) {
        return OWLAPIStreamUtils.asList(individuals.filter(i -> this.ontologies().anyMatch(o -> o.containsClassInSignature(i.getIRI()))));
    }

    private void generateChanges() {
        Stream<OWLNamedIndividual> inds = this.ontologies().flatMap(HasIndividualsInSignature::individualsInSignature);
        this.getPunnedIndividuals(inds).forEach(this::convertToAnnotations);
    }

    private void remove(Stream<? extends OWLAxiom> c, OWLOntology o) {
        c.forEach(ax -> this.addChange(new RemoveAxiom(o, (OWLAxiom)ax)));
    }

    private void remove(OWLDataProperty prop) {
        this.ontologies().forEach(o -> {
            this.remove((Stream<? extends OWLAxiom>)o.declarationAxioms(prop), (OWLOntology)o);
            this.remove((Stream<? extends OWLAxiom>)o.axioms(prop), (OWLOntology)o);
        });
    }

    private void remove(OWLNamedIndividual ind) {
        this.ontologies().forEach(o -> {
            this.remove((Stream<? extends OWLAxiom>)o.declarationAxioms(ind), (OWLOntology)o);
            this.remove((Stream<? extends OWLAxiom>)o.classAssertionAxioms(ind), (OWLOntology)o);
        });
    }

    private void convertToAnnotations(OWLNamedIndividual ind) {
        this.ontologies.forEach(ont -> this.addAnnotations(ind, (OWLOntology)ont));
        this.remove(ind);
    }

    protected void addAnnotations(OWLNamedIndividual ind, OWLOntology ont) {
        ont.dataPropertyAssertionAxioms(ind).filter(ax -> !((OWLDataPropertyExpression)ax.getProperty()).isAnonymous()).forEach(ax -> this.addAnnotation(ind, ont, (OWLDataPropertyAssertionAxiom)ax));
    }

    protected void addAnnotation(OWLNamedIndividual ind, OWLOntology ont, OWLDataPropertyAssertionAxiom ax) {
        this.addChange(new RemoveAxiom(ont, ax));
        this.addChange(new AddAxiom(ont, this.convertToAnnotation(ind, ax)));
        this.remove(((OWLDataPropertyExpression)ax.getProperty()).asOWLDataProperty());
    }

    private OWLAnnotationAssertionAxiom convertToAnnotation(OWLNamedIndividual ind, OWLDataPropertyAssertionAxiom ax) {
        OWLDataProperty hasIRI = ((OWLDataPropertyExpression)ax.getProperty()).asOWLDataProperty();
        OWLAnnotation anno = this.df.getOWLAnnotation(this.df.getOWLAnnotationProperty(hasIRI), (OWLAnnotationValue)ax.getObject());
        return this.df.getOWLAnnotationAssertionAxiom(ind.getIRI(), anno);
    }
}

