/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLDataOneOfImpl
extends OWLObjectImpl
implements OWLDataOneOf {
    private final List<OWLLiteral> values;

    public OWLDataOneOfImpl(Stream<? extends OWLLiteral> values) {
        OWLAPIPreconditions.checkNotNull(values, "values cannot be null");
        this.values = CollectionFactory.sortOptionally(values.map(l -> l).distinct());
    }

    public OWLDataOneOfImpl(Collection<? extends OWLLiteral> values) {
        this(OWLAPIPreconditions.checkNotNull(values, "values cannot be null").stream());
    }

    public OWLDataOneOfImpl(OWLLiteral value) {
        OWLAPIPreconditions.checkNotNull(value, "value cannot be null");
        this.values = Collections.singletonList(value);
    }

    @Override
    public Stream<OWLLiteral> values() {
        return this.values.stream();
    }
}

