/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class MaximumModalDepthFinder
implements OWLObjectVisitorEx<Integer> {
    private static final Integer _1 = 1;
    private static final Integer _0 = 0;

    @Override
    public Integer doDefault(Object o) {
        return _0;
    }

    Integer counter(Stream<? extends OWLObject> stream) {
        return stream.mapToInt(o -> o.accept(this)).max().orElse(0);
    }

    @Override
    public Integer visit(OWLSubClassOfAxiom axiom) {
        int subClassModalDepth = axiom.getSubClass().accept(this);
        int superClassModalDepth = axiom.getSuperClass().accept(this);
        return Math.max(subClassModalDepth, superClassModalDepth);
    }

    @Override
    public Integer visit(OWLOntology ontology) {
        return this.counter(ontology.logicalAxioms());
    }

    @Override
    public Integer visit(OWLObjectIntersectionOf ce) {
        return this.counter(ce.operands());
    }

    @Override
    public Integer visit(OWLObjectUnionOf ce) {
        return this.counter(ce.operands());
    }

    @Override
    public Integer visit(OWLObjectComplementOf ce) {
        return ce.getOperand().accept(this);
    }

    @Override
    public Integer visit(OWLObjectSomeValuesFrom ce) {
        return 1 + ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Integer visit(OWLObjectAllValuesFrom ce) {
        return 1 + ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Integer visit(OWLDisjointClassesAxiom axiom) {
        return this.counter(axiom.classExpressions());
    }

    @Override
    public Integer visit(OWLDataPropertyDomainAxiom axiom) {
        return ((OWLClassExpression)axiom.getDomain()).accept(this);
    }

    @Override
    public Integer visit(OWLObjectMinCardinality ce) {
        return 1 + ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Integer visit(OWLObjectPropertyDomainAxiom axiom) {
        return ((OWLClassExpression)axiom.getDomain()).accept(this);
    }

    @Override
    public Integer visit(OWLObjectExactCardinality ce) {
        return 1 + ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Integer visit(OWLObjectMaxCardinality ce) {
        return 1 + ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public Integer visit(OWLObjectHasSelf ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataSomeValuesFrom ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataAllValuesFrom ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataHasValue ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataMinCardinality ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataExactCardinality ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataMaxCardinality ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLClassAssertionAxiom axiom) {
        return axiom.getClassExpression().accept(this);
    }

    @Override
    public Integer visit(OWLEquivalentClassesAxiom axiom) {
        return this.counter(axiom.classExpressions());
    }
}

