/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.evaluation.RepositoryTripleSource;
import org.eclipse.rdf4j.repository.sail.SailBooleanQuery;
import org.eclipse.rdf4j.repository.sail.SailGraphQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailTupleQuery;
import org.eclipse.rdf4j.repository.sail.SailUpdate;

public class SailQueryPreparer
implements QueryPreparer {
    private final SailRepositoryConnection con;
    private final boolean includeInferred;
    private final TripleSource source;

    public SailQueryPreparer(SailRepositoryConnection con, boolean includeInferred) {
        this.con = con;
        this.includeInferred = includeInferred;
        this.source = new RepositoryTripleSource((RepositoryConnection)con, includeInferred);
    }

    public BooleanQuery prepare(ParsedBooleanQuery askQuery) {
        SailBooleanQuery query = new SailBooleanQuery(askQuery, this.con);
        query.setIncludeInferred(this.includeInferred);
        return query;
    }

    public TupleQuery prepare(ParsedTupleQuery tupleQuery) {
        SailTupleQuery query = new SailTupleQuery(tupleQuery, this.con);
        query.setIncludeInferred(this.includeInferred);
        return query;
    }

    public GraphQuery prepare(ParsedGraphQuery graphQuery) {
        SailGraphQuery query = new SailGraphQuery(graphQuery, this.con);
        query.setIncludeInferred(this.includeInferred);
        return query;
    }

    public Update prepare(ParsedUpdate graphUpdate) {
        SailUpdate update = new SailUpdate(graphUpdate, this.con);
        update.setIncludeInferred(this.includeInferred);
        return update;
    }

    public TripleSource getTripleSource() {
        return this.source;
    }
}

