/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.DBPropPrefix;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.DB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPropGraph
extends DBProp {
    public static Node_URI graphName = (Node_URI)DB.graphName.asNode();
    public static Node_URI graphType = (Node_URI)DB.graphType.asNode();
    public static Node_URI graphLSet = (Node_URI)DB.graphLSet.asNode();
    public static Node_URI graphPrefix = (Node_URI)DB.graphPrefix.asNode();
    public static Node_URI graphId = (Node_URI)DB.graphId.asNode();
    public static Node_URI stmtTable = (Node_URI)DB.stmtTable.asNode();
    public static Node_URI reifTable = (Node_URI)DB.reifTable.asNode();

    public DBPropGraph(SpecializedGraph g, String symbolicName, String type) {
        super(g);
        this.putPropString(graphName, symbolicName);
        this.putPropString(graphType, type);
    }

    public DBPropGraph(SpecializedGraph g, Node n) {
        super(g, n);
    }

    public DBPropGraph(SpecializedGraph g, String newSymbolicName, Graph oldProperties) {
        super(g);
        this.putPropString(graphName, newSymbolicName);
        ExtendedIterator<Triple> it = oldProperties.find(Node.ANY, Node.ANY, Node.ANY);
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            if (t.getPredicate().equals(graphName) || t.getPredicate().equals(graphId) || t.getPredicate().equals(stmtTable) || t.getPredicate().equals(reifTable)) continue;
            this.putPropNode((Node_URI)t.getPredicate(), t.getObject());
        }
    }

    public boolean begin() {
        return this.getDriver().xactOp(6);
    }

    public void conditionalCommit(boolean commit) {
        if (commit) {
            this.getDriver().xactOp(1);
        }
    }

    private DriverRDB getDriver() {
        return (DriverRDB)this.graph.getPSet().driver();
    }

    public void addLSet(DBPropLSet lset) {
        this.putPropNode(graphLSet, lset.getNode());
    }

    public void addPrefix(String prefix, String uri) {
        Node prefixNode = Node.createLiteral(prefix);
        Node uriNode = Node.createLiteral(uri);
        boolean commit = this.begin();
        Node B = this.bnodeForPrefix(prefixNode);
        if (B == null) {
            this.addPrefixMaplet(prefixNode, uriNode);
        } else {
            this.updatePrefixMaplet(B, uriNode);
        }
        this.conditionalCommit(commit);
    }

    private void updatePrefixMaplet(Node B, Node uriNode) {
        Node current = this.getPropNode(B, DBPropPrefix.prefixURI);
        if (!uriNode.equals(current)) {
            this.delete(B, DBPropPrefix.prefixURI, current);
            this.add(B, DBPropPrefix.prefixURI, uriNode);
        }
    }

    private void addPrefixMaplet(Node prefixNode, Node uriNode) {
        Node BB = Node.createAnon();
        this.add(this.self, graphPrefix, BB);
        this.add(BB, DBPropPrefix.prefixURI, uriNode);
        this.add(BB, DBPropPrefix.prefixValue, prefixNode);
    }

    private void add(Node S, Node P, Node O) {
        this.graph.add(Triple.create(S, P, O), DBPropGraph.newComplete());
    }

    private void delete(Node S, Node P, Node O) {
        this.graph.delete(Triple.create(S, P, O), DBPropGraph.newComplete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node bnodeForPrefix(Node prefixNode) {
        ExtendedIterator<Triple> A = this.graph.find(this.self, graphPrefix, Node.ANY, DBPropGraph.newComplete());
        try {
            while (A.hasNext()) {
                Node B = ((Triple)A.next()).getObject();
                if (!this.graph.contains(Triple.create(B, DBPropPrefix.prefixValue, prefixNode), DBPropGraph.newComplete())) continue;
                Node node = B;
                return node;
            }
            Node node = null;
            return node;
        }
        finally {
            A.close();
        }
    }

    public void removePrefix(String prefix) {
        Node prefixNode = Node.createLiteral(prefix);
        boolean commit = this.begin();
        Node B = this.bnodeForPrefix(prefixNode);
        if (B != null) {
            Node uriNode = this.getPropNode(B, DBPropPrefix.prefixURI);
            this.delete(this.self, graphPrefix, B);
            this.delete(B, DBPropPrefix.prefixURI, prefixNode);
            this.delete(B, DBPropPrefix.prefixValue, uriNode);
        }
        this.conditionalCommit(commit);
    }

    public void addGraphId(int id) {
        this.putPropString(graphId, Integer.toString(id));
    }

    public void addStmtTable(String table) {
        this.putPropString(stmtTable, table);
    }

    public void addReifTable(String table) {
        this.putPropString(reifTable, table);
    }

    public String getName() {
        return this.getPropString(graphName);
    }

    public String getType() {
        return this.getPropString(graphType);
    }

    public String getStmtTable() {
        return this.getPropString(stmtTable);
    }

    public String getReifTable() {
        return this.getPropString(reifTable);
    }

    public int getGraphId() {
        String i = this.getPropString(graphId);
        return i == null ? -1 : Integer.parseInt(i);
    }

    public ExtendedIterator<DBPropLSet> getAllLSets() {
        return this.graph.find(this.self, graphLSet, null, DBPropGraph.newComplete()).mapWith(new MapToLSet());
    }

    public ExtendedIterator<DBPropPrefix> getAllPrefixes() {
        return this.graph.find(this.self, graphPrefix, null, DBPropGraph.newComplete()).mapWith(new MapToPrefix());
    }

    public ExtendedIterator<Triple> listTriples() {
        ExtendedIterator<Triple> result = DBProp.listTriples(this.graph, this.self);
        ExtendedIterator<DBPropLSet> lsets = this.getAllLSets();
        while (lsets.hasNext()) {
            result = result.andThen(((DBPropLSet)lsets.next()).listTriples());
        }
        ExtendedIterator<DBPropPrefix> prefixes = this.getAllPrefixes();
        while (prefixes.hasNext()) {
            result = result.andThen(((DBPropPrefix)prefixes.next()).listTriples());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBPropGraph findPropGraphByName(SpecializedGraph graph, String name) {
        Node myNode = Node.createLiteral(name);
        ExtendedIterator<Triple> it = graph.find(null, graphName, myNode, DBPropGraph.newComplete());
        try {
            if (it.hasNext()) {
                DBPropGraph dBPropGraph = new DBPropGraph(graph, ((Triple)it.next()).getSubject());
                return dBPropGraph;
            }
            DBPropGraph dBPropGraph = null;
            return dBPropGraph;
        }
        finally {
            it.close();
        }
    }

    public boolean isDBPropGraphOk(String name) {
        String s = this.getName();
        boolean res = s == null ? false : s.equals(name);
        res &= this.getGraphId() != -1;
        res &= this.getType() != null;
        res &= this.getStmtTable() != null;
        return res &= this.getReifTable() != null;
    }

    @Override
    public void remove() {
        ExtendedIterator<DBPropPrefix> it = this.getAllPrefixes();
        while (it.hasNext()) {
            ((DBPropPrefix)it.next()).remove();
        }
        ExtendedIterator<DBPropLSet> it2 = this.getAllLSets();
        while (it.hasNext()) {
            ((DBPropPrefix)it.next()).remove();
        }
        super.remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapToPrefix
    implements Map1<Triple, DBPropPrefix> {
        private MapToPrefix() {
        }

        @Override
        public DBPropPrefix map1(Triple t) {
            return new DBPropPrefix(DBPropGraph.this.graph, t.getObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapToLSet
    implements Map1<Triple, DBPropLSet> {
        private MapToLSet() {
        }

        @Override
        public DBPropLSet map1(Triple t) {
            return new DBPropLSet(DBPropGraph.this.graph, t.getObject());
        }
    }
}

