/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.dataset;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryWrapper;
import org.openrdf.repository.dataset.DatasetRepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParserRegistry;

public class DatasetRepository
extends RepositoryWrapper {
    private Map<URL, Long> lastModified = new ConcurrentHashMap<URL, Long>();

    public DatasetRepository() {
    }

    public DatasetRepository(SailRepository delegate) {
        super((Repository)delegate);
    }

    public void setDelegate(Repository delegate) {
        if (!(delegate instanceof SailRepository)) {
            throw new IllegalArgumentException("delegate must be a SailRepository, is: " + delegate.getClass());
        }
        super.setDelegate(delegate);
    }

    public SailRepository getDelegate() {
        return (SailRepository)super.getDelegate();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        return new DatasetRepositoryConnection(this, this.getDelegate().getConnection());
    }

    public void loadDataset(URL url, URI context, ParserConfig config) throws RepositoryException {
        try {
            Long since = this.lastModified.get(url);
            URLConnection urlCon = url.openConnection();
            if (since != null) {
                urlCon.setIfModifiedSince(since);
            }
            if (since == null || since < urlCon.getLastModified()) {
                this.load(url, urlCon, context, config);
            }
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load(URL url, URLConnection urlCon, URI context, ParserConfig config) throws RepositoryException, RDFParseException, IOException {
        RDFFormat format;
        long modified = urlCon.getLastModified();
        if (this.lastModified.containsKey(url) && this.lastModified.get(url) >= modified) {
            return;
        }
        String mimeType = urlCon.getContentType();
        int semiColonIdx = mimeType.indexOf(59);
        if (semiColonIdx >= 0) {
            mimeType = mimeType.substring(0, semiColonIdx);
        }
        if ((format = (RDFFormat)RDFParserRegistry.getInstance().getFileFormatForMIMEType(mimeType)) == null) {
            format = (RDFFormat)RDFParserRegistry.getInstance().getFileFormatForFileName(url.getPath());
        }
        InputStream stream = urlCon.getInputStream();
        try {
            RepositoryConnection repCon = super.getConnection();
            try {
                repCon.setParserConfig(config);
                repCon.begin();
                repCon.clear(new Resource[]{context});
                repCon.add(stream, url.toExternalForm(), format, new Resource[]{context});
                repCon.commit();
                this.lastModified.put(url, modified);
            }
            finally {
                repCon.close();
            }
        }
        finally {
            stream.close();
        }
    }
}

