/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.federated.structures.FedXBooleanQuery;
import org.eclipse.rdf4j.federated.structures.FedXGraphQuery;
import org.eclipse.rdf4j.federated.structures.FedXTupleQuery;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailBooleanQuery;
import org.eclipse.rdf4j.repository.sail.SailGraphQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailTupleQuery;
import org.eclipse.rdf4j.sail.SailConnection;

public class FedXRepositoryConnection
extends SailRepositoryConnection {
    public static final String BINDING_ORIGINAL_QUERY = "__originalQuery";
    public static final String BINDING_ORIGINAL_QUERY_TYPE = "__originalQueryType";
    public static final String BINDING_ORIGINAL_MAX_EXECUTION_TIME = "__originalQueryMaxExecutionTime";
    public static final Set<String> FEDX_BINDINGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"__originalQuery", "__originalQueryType", "__originalQueryMaxExecutionTime"}));
    private final FederationContext federationContext;

    protected FedXRepositoryConnection(FedXRepository repository, SailConnection sailConnection) {
        super((SailRepository)repository, sailConnection);
        this.federationContext = repository.getFederationContext();
    }

    public SailQuery prepareQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        Object q = super.prepareQuery(ql, queryString, baseURI);
        if (q instanceof SailTupleQuery) {
            this.insertOriginalQueryString((SailQuery)q, queryString, QueryType.SELECT);
            q = new FedXTupleQuery((SailTupleQuery)q);
        } else if (q instanceof GraphQuery) {
            this.insertOriginalQueryString((SailQuery)q, queryString, QueryType.CONSTRUCT);
            q = new FedXGraphQuery((SailGraphQuery)q);
        } else if (q instanceof SailBooleanQuery) {
            this.insertOriginalQueryString((SailQuery)q, queryString, QueryType.ASK);
            q = new FedXBooleanQuery((SailBooleanQuery)q);
        }
        this.setIncludeInferredDefault((SailQuery)q);
        return q;
    }

    public FedXTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        SailTupleQuery q = super.prepareTupleQuery(ql, queryString, baseURI);
        this.insertOriginalQueryString((SailQuery)q, queryString, QueryType.SELECT);
        this.setIncludeInferredDefault((SailQuery)q);
        return new FedXTupleQuery(q);
    }

    public FedXGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        SailGraphQuery q = super.prepareGraphQuery(ql, queryString, baseURI);
        this.insertOriginalQueryString((SailQuery)q, queryString, QueryType.CONSTRUCT);
        this.setIncludeInferredDefault((SailQuery)q);
        return new FedXGraphQuery(q);
    }

    public SailBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        SailBooleanQuery q = super.prepareBooleanQuery(ql, queryString, baseURI);
        this.insertOriginalQueryString((SailQuery)q, queryString, QueryType.ASK);
        this.setIncludeInferredDefault((SailQuery)q);
        return new FedXBooleanQuery(q);
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        return super.prepareUpdate(ql, update, baseURI);
    }

    private void setIncludeInferredDefault(SailQuery query) {
        query.setIncludeInferred(this.federationContext.getConfig().getIncludeInferredDefault());
    }

    private void insertOriginalQueryString(SailQuery query, String queryString, QueryType qt) {
        query.setBinding(BINDING_ORIGINAL_QUERY, (Value)FedXUtil.literal(queryString));
        query.setBinding(BINDING_ORIGINAL_QUERY_TYPE, (Value)FedXUtil.literal(qt.name()));
    }
}

