/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.updatebuilder;

import java.util.Map;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.shared.PrefixMapping;

public class PrefixHandler {
    private final PrefixMapping pMap;

    public PrefixHandler(PrefixMapping pMap) {
        this.pMap = pMap;
    }

    public PrefixHandler() {
        this.pMap = PrefixMapping.Factory.create();
    }

    private static String canonicalPfx(String x) {
        if (x.endsWith(":")) {
            return x.substring(0, x.length() - 1);
        }
        return x;
    }

    public void addPrefix(String pfx, String uri) {
        this.pMap.setNsPrefix(PrefixHandler.canonicalPfx(pfx), uri);
    }

    public void clearPrefixes() {
        this.pMap.clearNsPrefixMap();
    }

    public void addPrefixes(Map<String, String> prefixes) {
        for (Map.Entry<String, String> e : prefixes.entrySet()) {
            this.addPrefix(e.getKey(), e.getValue());
        }
    }

    public PrefixMapping getPrefixes() {
        return this.pMap;
    }

    public ExprFactory getExprFactory() {
        return new ExprFactory(this.pMap);
    }

    public void addPrefixes(PrefixMapping prefixes) {
        this.pMap.setNsPrefixes(prefixes);
    }
}

