/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfjson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.rdfjson.RDFJSONUtility;

public class RDFJSONWriter
extends AbstractRDFWriter
implements RDFWriter {
    private Writer writer;
    private OutputStream outputStream;
    private Model graph;
    private final RDFFormat actualFormat;

    public RDFJSONWriter(OutputStream out, RDFFormat actualFormat) {
        this.outputStream = out;
        this.actualFormat = actualFormat;
    }

    public RDFJSONWriter(Writer writer, RDFFormat actualFormat) {
        this.writer = writer;
        this.actualFormat = actualFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRDF() throws RDFHandlerException {
        block34: {
            try {
                if (this.writer != null) {
                    try (JsonGenerator jg = RDFJSONUtility.JSON_FACTORY.createGenerator(this.writer);){
                        RDFJSONWriter.modelToRdfJsonInternal(this.graph, this.getWriterConfig(), jg);
                        break block34;
                    }
                    finally {
                        this.writer.flush();
                    }
                }
                if (this.outputStream != null) {
                    try (JsonGenerator jg = RDFJSONUtility.JSON_FACTORY.createGenerator(this.outputStream);){
                        RDFJSONWriter.modelToRdfJsonInternal(this.graph, this.getWriterConfig(), jg);
                        break block34;
                    }
                    finally {
                        this.outputStream.flush();
                    }
                }
                throw new IllegalStateException("The output stream and the writer were both null.");
            }
            catch (IOException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
    }

    public RDFFormat getRDFFormat() {
        return this.actualFormat;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet results = new HashSet(super.getSupportedSettings());
        results.add(BasicWriterSettings.PRETTY_PRINT);
        return results;
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        this.graph.add((Object)statement);
    }

    public void startRDF() throws RDFHandlerException {
        this.graph = new TreeModel();
    }

    public static void writeObject(Value object, Set<Resource> contexts, JsonGenerator jg) throws JsonGenerationException, IOException {
        jg.writeStartObject();
        if (object instanceof Literal) {
            jg.writeObjectField("value", (Object)object.stringValue());
            jg.writeObjectField("type", (Object)"literal");
            Literal l = (Literal)object;
            if (Literals.isLanguageLiteral((Literal)l)) {
                jg.writeObjectField("lang", l.getLanguage().orElse(null));
            } else {
                jg.writeObjectField("datatype", (Object)l.getDatatype().stringValue());
            }
        } else if (object instanceof BNode) {
            jg.writeObjectField("value", (Object)RDFJSONWriter.resourceToString((Resource)((BNode)object)));
            jg.writeObjectField("type", (Object)"bnode");
        } else if (object instanceof IRI) {
            jg.writeObjectField("value", (Object)RDFJSONWriter.resourceToString((Resource)((IRI)object)));
            jg.writeObjectField("type", (Object)"uri");
        }
        if (!(contexts == null || contexts.isEmpty() || contexts.size() == 1 && contexts.iterator().next() == null)) {
            jg.writeArrayFieldStart("graphs");
            for (Resource nextContext : contexts) {
                if (nextContext == null) {
                    jg.writeNull();
                    continue;
                }
                jg.writeString(RDFJSONWriter.resourceToString(nextContext));
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    public static String resourceToString(Resource uriOrBnode) {
        if (uriOrBnode instanceof IRI) {
            return uriOrBnode.stringValue();
        }
        return "_:" + ((BNode)uriOrBnode).getID();
    }

    public static void modelToRdfJsonInternal(Model graph, WriterConfig writerConfig, JsonGenerator jg) throws IOException, JsonGenerationException {
        if (((Boolean)writerConfig.get(BasicWriterSettings.PRETTY_PRINT)).booleanValue()) {
            DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
            DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
            jg.setPrettyPrinter((PrettyPrinter)pp);
        }
        jg.writeStartObject();
        for (Resource nextSubject : graph.subjects()) {
            jg.writeObjectFieldStart(RDFJSONWriter.resourceToString(nextSubject));
            for (IRI nextPredicate : graph.filter(nextSubject, null, null, new Resource[0]).predicates()) {
                jg.writeArrayFieldStart(nextPredicate.stringValue());
                for (Value nextObject : graph.filter(nextSubject, nextPredicate, null, new Resource[0]).objects()) {
                    Set contexts = graph.filter(nextSubject, nextPredicate, nextObject, new Resource[0]).contexts();
                    RDFJSONWriter.writeObject(nextObject, contexts, jg);
                }
                jg.writeEndArray();
            }
            jg.writeEndObject();
        }
        jg.writeEndObject();
    }
}

