/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;

public class SPARQLRepositoryConfig
extends RepositoryImplConfigBase {
    public static final URI QUERY_ENDPOINT = new URIImpl("http://www.openrdf.org/config/repository/sparql#query-endpoint");
    public static final URI UPDATE_ENDPOINT = new URIImpl("http://www.openrdf.org/config/repository/sparql#update-endpoint");
    private String queryEndpointUrl;
    private String updateEndpointUrl;

    public SPARQLRepositoryConfig() {
        super("openrdf:SPARQLRepository");
    }

    public SPARQLRepositoryConfig(String queryEndpointUrl) {
        this.setQueryEndpointUrl(queryEndpointUrl);
    }

    public SPARQLRepositoryConfig(String queryEndpointUrl, String updateEndpointUrl) {
        this(queryEndpointUrl);
        this.setUpdateEndpointUrl(updateEndpointUrl);
    }

    public String getQueryEndpointUrl() {
        return this.queryEndpointUrl;
    }

    public void setQueryEndpointUrl(String url) {
        this.queryEndpointUrl = url;
    }

    public String getUpdateEndpointUrl() {
        return this.updateEndpointUrl;
    }

    public void setUpdateEndpointUrl(String url) {
        this.updateEndpointUrl = url;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.getQueryEndpointUrl() == null) {
            throw new RepositoryConfigException("No endpoint URL specified for SPARQL repository");
        }
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        ValueFactory vf = graph.getValueFactory();
        if (this.getQueryEndpointUrl() != null) {
            graph.add(implNode, QUERY_ENDPOINT, (Value)vf.createURI(this.getQueryEndpointUrl()), new Resource[0]);
        }
        if (this.getUpdateEndpointUrl() != null) {
            graph.add(implNode, UPDATE_ENDPOINT, (Value)vf.createURI(this.getUpdateEndpointUrl()), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            URI uri = GraphUtil.getOptionalObjectURI((Graph)graph, (Resource)implNode, (URI)QUERY_ENDPOINT);
            if (uri != null) {
                this.setQueryEndpointUrl(uri.stringValue());
            }
            if ((uri = GraphUtil.getOptionalObjectURI((Graph)graph, (Resource)implNode, (URI)UPDATE_ENDPOINT)) != null) {
                this.setUpdateEndpointUrl(uri.stringValue());
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

