/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.manager;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigUtil;
import org.openrdf.repository.manager.RepositoryInfo;
import org.openrdf.repository.sail.config.ProxyRepositorySchema;
import org.openrdf.repository.sail.config.RepositoryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryManager
implements RepositoryResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Repository> initializedRepositories = new HashMap<String, Repository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            Repository repo = this.initializedRepositories.get("SYSTEM");
            return repo != null && repo.isInitialized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws RepositoryException {
        Repository systemRepository = this.createSystemRepository();
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.initializedRepositories.put("SYSTEM", systemRepository);
        }
    }

    protected abstract Repository createSystemRepository() throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getSystemRepository() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Repository Manager is not initialized");
        }
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            return this.initializedRepositories.get("SYSTEM");
        }
    }

    public String getNewRepositoryID(String baseName) throws RepositoryException, RepositoryConfigException {
        if (baseName != null) {
            baseName = baseName.trim();
            int length = baseName.length();
            StringBuilder buffer = new StringBuilder(length);
            for (char c : baseName.toCharArray()) {
                if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.') {
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (c == '\"' || c == '\'') continue;
                buffer.append('-');
            }
            baseName = buffer.toString();
        }
        if (baseName != null && baseName.length() > 0 && !this.hasRepositoryConfig(baseName)) {
            return baseName;
        }
        if (baseName == null || baseName.length() == 0) {
            baseName = "repository-";
        } else if (!baseName.endsWith("-")) {
            baseName = baseName + "-";
        }
        int index = 2;
        while (this.hasRepositoryConfig(baseName + index)) {
            ++index;
        }
        return baseName + index;
    }

    public Set<String> getRepositoryIDs() throws RepositoryException {
        return RepositoryConfigUtil.getRepositoryIDs((Repository)this.getSystemRepository());
    }

    public boolean hasRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        return RepositoryConfigUtil.hasRepositoryConfig((Repository)this.getSystemRepository(), (String)repositoryID);
    }

    public RepositoryConfig getRepositoryConfig(String repositoryID) throws RepositoryConfigException, RepositoryException {
        return RepositoryConfigUtil.getRepositoryConfig((Repository)this.getSystemRepository(), (String)repositoryID);
    }

    public void addRepositoryConfig(RepositoryConfig config) throws RepositoryException, RepositoryConfigException {
        RepositoryConfigUtil.updateRepositoryConfigs((Repository)this.getSystemRepository(), (RepositoryConfig[])new RepositoryConfig[]{config});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean removeRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        this.logger.debug("Removing repository configuration for {}.", (Object)repositoryID);
        boolean isRemoved = false;
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            isRemoved = RepositoryConfigUtil.removeRepositoryConfigs((Repository)this.getSystemRepository(), (String[])new String[]{repositoryID});
            if (isRemoved) {
                this.logger.debug("Shutdown repository {} after removal of configuration.", (Object)repositoryID);
                Repository repository = this.initializedRepositories.remove(repositoryID);
                if (repository != null && repository.isInitialized()) {
                    repository.shutDown();
                }
                try {
                    this.cleanUpRepository(repositoryID);
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to clean up resources for removed repository " + repositoryID, (Throwable)e);
                }
            }
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSafeToRemove(String repositoryID) throws RepositoryException {
        RepositoryConnection connection = this.getSystemRepository().getConnection();
        try {
            boolean bl = !connection.hasStatement(null, ProxyRepositorySchema.PROXIED_ID, (Value)connection.getValueFactory().createLiteral(repositoryID), false, new Resource[0]);
            return bl;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        this.logger.debug("Removing repository {}.", (Object)repositoryID);
        boolean isRemoved = false;
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            isRemoved = RepositoryConfigUtil.removeRepositoryConfigs((Repository)this.getSystemRepository(), (String[])new String[]{repositoryID});
            if (isRemoved) {
                this.logger.debug("Shutdown repository {} after removal of configuration.", (Object)repositoryID);
                Repository repository = this.initializedRepositories.remove(repositoryID);
                if (repository != null && repository.isInitialized()) {
                    repository.shutDown();
                }
                try {
                    this.cleanUpRepository(repositoryID);
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to clean up resources for removed repository " + repositoryID, (Throwable)e);
                }
            }
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(String identity) throws RepositoryConfigException, RepositoryException {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            Repository result = this.initializedRepositories.get(identity);
            if (result != null && !result.isInitialized()) {
                this.initializedRepositories.remove(result);
                result = null;
            }
            if (result == null && (result = this.createRepository(identity)) != null) {
                this.initializedRepositories.put(identity, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getInitializedRepositoryIDs() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return new HashSet<String>(this.initializedRepositories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Repository> getInitializedRepositories() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return new ArrayList<Repository>(this.initializedRepositories.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository getInitializedRepository(String repositoryID) {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return this.initializedRepositories.get(repositoryID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository removeInitializedRepository(String repositoryID) {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return this.initializedRepositories.remove(repositoryID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInitializedRepositories() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            Iterator<Repository> iter = this.initializedRepositories.values().iterator();
            while (iter.hasNext()) {
                if (iter.next().isInitialized()) continue;
                iter.remove();
            }
        }
    }

    public Collection<Repository> getAllRepositories() throws RepositoryConfigException, RepositoryException {
        Set<String> idSet = this.getRepositoryIDs();
        ArrayList<Repository> result = new ArrayList<Repository>(idSet.size());
        for (String id : idSet) {
            result.add(this.getRepository(id));
        }
        return result;
    }

    protected abstract Repository createRepository(String var1) throws RepositoryConfigException, RepositoryException;

    public abstract RepositoryInfo getRepositoryInfo(String var1) throws RepositoryException;

    public Collection<RepositoryInfo> getAllRepositoryInfos() throws RepositoryException {
        return this.getAllRepositoryInfos(false);
    }

    public Collection<RepositoryInfo> getAllUserRepositoryInfos() throws RepositoryException {
        return this.getAllRepositoryInfos(true);
    }

    public abstract Collection<RepositoryInfo> getAllRepositoryInfos(boolean var1) throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.logger.debug("Refreshing repository information in manager...");
        try {
            RepositoryConnection cleanupCon = this.getSystemRepository().getConnection();
            try {
                Map<String, Repository> map = this.initializedRepositories;
                synchronized (map) {
                    Iterator<Map.Entry<String, Repository>> iter = this.initializedRepositories.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, Repository> entry = iter.next();
                        String repositoryID = entry.getKey();
                        Repository repository = entry.getValue();
                        if ("SYSTEM".equals(repositoryID)) continue;
                        iter.remove();
                        this.refreshRepository(cleanupCon, repositoryID, repository);
                    }
                }
            }
            finally {
                cleanupCon.close();
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Failed to refresh repositories", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            for (Repository repository : this.initializedRepositories.values()) {
                try {
                    if (!repository.isInitialized()) continue;
                    repository.shutDown();
                }
                catch (RepositoryException e) {
                    this.logger.error("Repository shut down failed", (Throwable)e);
                }
            }
            this.initializedRepositories.clear();
        }
    }

    void refreshRepository(RepositoryConnection con, String repositoryID, Repository repository) {
        this.logger.debug("Refreshing repository {}...", (Object)repositoryID);
        try {
            if (repository.isInitialized()) {
                repository.shutDown();
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Failed to shut down repository", (Throwable)e);
        }
        this.cleanupIfRemoved(con, repositoryID);
    }

    void cleanupIfRemoved(RepositoryConnection con, String repositoryID) {
        try {
            if (RepositoryConfigUtil.getContext((RepositoryConnection)con, (String)repositoryID) == null) {
                this.logger.debug("Cleaning up repository {}, its configuration has been removed", (Object)repositoryID);
                this.cleanUpRepository(repositoryID);
            } else {
                this.logger.debug("Repository {} should not be cleaned up.", (Object)repositoryID);
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Failed to process repository configuration changes", (Throwable)e);
        }
        catch (RepositoryConfigException e) {
            this.logger.warn("Unable to determine if configuration for {} is still present in the system repository", (Object)repositoryID);
        }
        catch (IOException e) {
            this.logger.warn("Unable to remove data dir for removed repository {} ", (Object)repositoryID);
        }
    }

    protected abstract void cleanUpRepository(String var1) throws IOException;

    public abstract URL getLocation() throws MalformedURLException;
}

