/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.constraint;

import org.eclipse.rdf4j.sparqlbuilder.constraint.ConnectiveOperator;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Operand;
import org.eclipse.rdf4j.sparqlbuilder.constraint.SparqlOperator;

abstract class Operation<T extends Operation<T>>
extends Expression<T> {
    protected int operandLimit;

    Operation(SparqlOperator operator) {
        this(operator, -1);
    }

    Operation(SparqlOperator operator, int operandLimit) {
        super(operator);
        this.operandLimit = operandLimit;
        if (operator instanceof ConnectiveOperator) {
            this.parenthesize();
        }
    }

    T addOperand(Operand operand) {
        if (this.isBelowOperatorLimit()) {
            return (T)((Operation)super.addOperand(operand));
        }
        return (T)this;
    }

    @Override
    public String getQueryString() {
        return this.isAtOperatorLimit() ? super.getQueryString() : "";
    }

    protected boolean isBelowOperatorLimit() {
        return this.operandLimit < 0 || this.elements.size() < this.operandLimit;
    }

    protected boolean isAtOperatorLimit() {
        return this.operandLimit < 0 || this.elements.size() == this.operandLimit;
    }
}

