/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.extension;

import com.tinkerpop.rexster.extension.ExtensionSegmentSet;

public class ExtensionAllowed {
    private final String namespace;

    public ExtensionAllowed(String namespace) {
        if (namespace == null || !namespace.matches("([\\w-]+|\\*):([\\w-]+|\\*)") || namespace.startsWith("*") && namespace.equals("*.*")) {
            throw new IllegalArgumentException("The namespace must match the format of *:*, namespace:*, namespace:extension");
        }
        this.namespace = namespace;
    }

    public boolean isExtensionAllowed(ExtensionSegmentSet extensionSegmentSet) {
        boolean allowed = false;
        if (this.namespace.equals("*:*")) {
            allowed = true;
        } else if (this.namespace.equals(extensionSegmentSet.getNamespace() + ":*")) {
            allowed = true;
        } else if (this.namespace.equals(extensionSegmentSet.getNamespace() + ":" + extensionSegmentSet.getExtension())) {
            allowed = true;
        }
        return allowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionAllowed that = (ExtensionAllowed)o;
        return this.namespace.equals(that.namespace);
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }
}

