/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import uk.ac.manchester.cs.factplusplusad.CardinalityEvaluatorBase;
import uk.ac.manchester.cs.factplusplusad.Signature;

class UpperBoundDirectEvaluator
extends CardinalityEvaluatorBase {
    UpperBoundDirectEvaluator(Signature s) {
        super(s);
    }

    @Override
    int getEntityValue(OWLEntity entity) {
        if (entity.isTopEntity()) {
            return this.noUpperValue();
        }
        if (entity.isBottomEntity()) {
            return this.anyUpperValue();
        }
        return this.getAllNoneUpper(this.botCLocal() && this.nc(entity));
    }

    @Override
    int getForallValue(OWLPropertyExpression r, OWLPropertyRange c) {
        return this.getAllNoneUpper(this.isTopEquivalent((OWLObject)r) && this.isLowerGE(this.getLowerBoundComplement((OWLObject)c), 1));
    }

    @Override
    int getMinValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        if (m <= 0) {
            return this.getNoneValue();
        }
        if (this.isBotEquivalent((OWLObject)r)) {
            return this.anyUpperValue();
        }
        return this.getAllNoneUpper(this.isUpperLT(this.getUpperBoundDirect((OWLObject)c), m));
    }

    @Override
    int getMaxValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        if (!this.isTopEquivalent((OWLObject)r)) {
            return this.noUpperValue();
        }
        return this.getAllNoneUpper(this.isLowerGT(this.getLowerBoundDirect((OWLObject)c), m));
    }

    @Override
    int getExactValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        return this.minUpperValue(this.getMinValue(m, r, c), this.getMaxValue(m, r, c));
    }

    <C extends OWLObject> int getAndValue(HasOperands<C> expr) {
        AtomicInteger min = new AtomicInteger(this.noUpperValue());
        expr.operands().forEach(p -> min.set(this.minUpperValue(min.get(), this.getUpperBoundDirect((OWLObject)p))));
        return min.get();
    }

    <C extends OWLObject> int getOrValue(HasOperands<C> expr) {
        int sum = 0;
        Iterator it = expr.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            int n = this.getUpperBoundDirect(p);
            if (n == this.noUpperValue()) {
                return this.noUpperValue();
            }
            sum += n;
        }
        return sum;
    }

    public void visit(OWLObjectComplementOf expr) {
        this.value = this.getUpperBoundComplement(expr.getOperand());
    }

    public void visit(OWLObjectIntersectionOf expr) {
        this.value = this.getAndValue((HasOperands)expr);
    }

    public void visit(OWLObjectUnionOf expr) {
        this.value = this.getOrValue((HasOperands)expr);
    }

    public void visit(OWLObjectOneOf expr) {
        this.value = (int)expr.individuals().count();
    }

    public void visit(OWLObjectHasSelf expr) {
        this.value = this.getAllNoneUpper(this.isBotEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLObjectHasValue expr) {
        this.value = this.getAllNoneUpper(this.isBotEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLDataHasValue expr) {
        this.value = this.getAllNoneUpper(this.isBotEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLObjectInverseOf expr) {
        this.value = this.getUpperBoundDirect((OWLObject)expr.getInverseProperty());
    }

    public void visit(OWLSubPropertyChainOfAxiom expr) {
        for (OWLObjectPropertyExpression p : expr.getPropertyChain()) {
            if (!this.isBotEquivalent((OWLObject)p)) continue;
            this.value = this.anyUpperValue();
            return;
        }
        this.value = this.noUpperValue();
    }

    public void visit(OWLLiteral o) {
        this.value = 1;
    }

    public void visit(OWLDataComplementOf expr) {
        this.value = this.getUpperBoundComplement((OWLObject)expr.getDataRange());
    }

    public void visit(OWLDataIntersectionOf expr) {
        this.value = this.getAndValue((HasOperands)expr);
    }

    public void visit(OWLDataUnionOf expr) {
        this.value = this.getOrValue((HasOperands)expr);
    }

    public void visit(OWLDataOneOf expr) {
        this.value = (int)expr.values().count();
    }
}

