/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.util;

import com.bigdata.rdf.graph.EdgesEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.openrdf.model.Resource;

public class VertexDistribution {
    private final Random r;
    private final Map<Resource, VertexSample> samples = new HashMap<Resource, VertexSample>();
    private final Map<Integer, VertexSample> indexOf = new HashMap<Integer, VertexSample>();

    public VertexDistribution(Random r) {
        if (r == null) {
            throw new IllegalArgumentException();
        }
        this.r = r;
    }

    public void addOutEdgeSample(Resource v) {
        VertexSample s = this.samples.get(v);
        if (s == null) {
            s = new VertexSample(v, 0, 1);
            this.samples.put(v, s);
            this.indexOf.put(this.samples.size() - 1, s);
        }
    }

    public void addInEdgeSample(Resource v) {
        VertexSample s = this.samples.get(v);
        if (s == null) {
            s = new VertexSample(v, 1, 0);
            this.samples.put(v, s);
            this.indexOf.put(this.samples.size() - 1, s);
        }
    }

    public int size() {
        return this.samples.size();
    }

    double[] getVector(EdgesEnum edges, boolean normalize) {
        if (edges == null) {
            throw new IllegalArgumentException();
        }
        double[] a = new double[this.samples.size()];
        if (a.length == 0) {
            return a;
        }
        int i = 0;
        double sum = 0.0;
        for (VertexSample s : this.samples.values()) {
            double d;
            switch (edges) {
                case NoEdges: {
                    d = 1.0;
                    break;
                }
                case InEdges: {
                    d = s.in;
                    break;
                }
                case OutEdges: {
                    d = s.out;
                    break;
                }
                case AllEdges: {
                    d = s.in + s.out;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (d == 0.0) continue;
            a[i] = normalize ? (sum += d) : d;
            ++i;
        }
        int nfound = i;
        if (nfound == 0) {
            return new double[0];
        }
        if (normalize) {
            i = 0;
            while (i < a.length) {
                int n = i++;
                a[n] = a[n] / sum;
            }
        }
        if (nfound < a.length) {
            double[] b = new double[nfound];
            System.arraycopy(a, 0, b, 0, nfound);
            return b;
        }
        return a;
    }

    public Resource[] getWeightedSample(int desiredSampleSize, EdgesEnum edges) {
        if (this.samples.isEmpty()) {
            return new Resource[0];
        }
        double[] norm = this.getVector(edges, true);
        int limit = (int)Math.min((long)desiredSampleSize * 3L, Integer.MAX_VALUE);
        int round = 0;
        HashSet<Resource> selected = new HashSet<Resource>();
        while (selected.size() < desiredSampleSize && round++ < limit) {
            double f;
            int i;
            double d = this.r.nextDouble();
            double sum = 0.0;
            for (i = 0; i < norm.length && !((sum += (f = norm[i])) > d); ++i) {
            }
            Resource v = this.indexOf.get((Object)Integer.valueOf((int)i)).v;
            selected.add(v);
        }
        return selected.toArray(new Resource[selected.size()]);
    }

    public Resource[] getUnweightedSample(int desiredSampleSize, EdgesEnum edges) {
        if (this.samples.isEmpty()) {
            return new Resource[0];
        }
        double[] vec = this.getVector(edges, true);
        int limit = (int)Math.min((long)desiredSampleSize * 3L, Integer.MAX_VALUE);
        int round = 0;
        HashSet<Resource> selected = new HashSet<Resource>();
        while (selected.size() < desiredSampleSize && round++ < limit) {
            int i = this.r.nextInt(vec.length);
            Resource v = this.indexOf.get((Object)Integer.valueOf((int)i)).v;
            selected.add(v);
        }
        return selected.toArray(new Resource[selected.size()]);
    }

    public String toString() {
        return super.toString() + "{size=" + this.size() + "}";
    }

    private static class VertexSample {
        public final Resource v;
        public int in;
        public int out;

        public VertexSample(Resource v, int in, int out) {
            this.v = v;
            this.in = in;
            this.out = out;
        }

        public String toString() {
            return this.getClass().getName() + "{v=" + this.v + ",#in=" + this.in + ",#out=" + this.out + "}";
        }
    }
}

