/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.frontier;

import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.impl.util.IArraySlice;
import com.bigdata.rdf.graph.impl.util.IManagedArray;
import com.bigdata.rdf.graph.impl.util.ManagedArray;
import java.util.Arrays;
import java.util.Iterator;
import org.openrdf.model.Value;

public class StaticFrontier2
implements IStaticFrontier {
    private final IManagedArray<Value> backing = new ManagedArray<Value>(Value.class);
    private IArraySlice<Value> vertices = this.backing.slice(0, 0);
    private boolean compact = true;

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    public void setCompact(boolean newValue) {
        this.compact = newValue;
    }

    @Override
    public int size() {
        return this.vertices.len();
    }

    @Override
    public boolean isEmpty() {
        return this.vertices.len() == 0;
    }

    @Override
    public Iterator<Value> iterator() {
        return this.vertices.iterator();
    }

    public void resetAndEnsureCapacity(int minCapacity) {
        int len0 = this.size();
        this.backing.ensureCapacity(minCapacity);
        int len1 = this.backing.len();
        if (len1 > len0) {
            Value[] a = (Value[])this.backing.array();
            for (int i = len0; i < len1 && a[i] != null; ++i) {
                a[i] = null;
            }
        }
        this.vertices = this.backing.slice(0, minCapacity);
    }

    public void copyIntoResetFrontier(int off, IArraySlice<Value> slice) {
        this.backing.put(off, (Value[])slice.array(), slice.off(), slice.len());
    }

    @Override
    public void resetFrontier(int minCapacity, boolean sort, Iterator<Value> itr) {
        this.copyScheduleIntoFrontier(minCapacity, itr);
        if (sort) {
            Arrays.sort(this.backing.array(), 0, this.vertices.len());
        }
    }

    private void copyScheduleIntoFrontier(int minCapacity, Iterator<Value> itr) {
        this.backing.ensureCapacity(minCapacity);
        Value[] a = (Value[])this.backing.array();
        int nvertices = 0;
        while (itr.hasNext()) {
            Value v = itr.next();
            a[nvertices++] = v;
        }
        for (int i = nvertices; i < a.length && a[i] != null; ++i) {
            a[i] = null;
        }
        this.vertices = this.backing.slice(0, nvertices);
    }

    public String toString() {
        return this.getClass().getName() + "{size=" + this.size() + ",compact=" + this.isCompact() + ",capacity=" + this.backing.capacity() + "}";
    }
}

