/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl;

import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.impl.DaemonThreadFactory;
import com.bigdata.rdf.graph.impl.GASContext;
import com.bigdata.rdf.graph.impl.GASState;
import com.bigdata.rdf.graph.impl.VertexTaskFactory;
import com.bigdata.rdf.graph.impl.frontier.StaticFrontier2;
import com.bigdata.rdf.graph.impl.scheduler.CHMScheduler;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.openrdf.model.Value;

public abstract class GASEngine
implements IGASEngine {
    private final ExecutorService executorService;
    private final int nthreads;
    private final AtomicReference<Class<IGASSchedulerImpl>> schedulerClassRef;

    @Override
    public int getNThreads() {
        return this.nthreads;
    }

    public GASEngine(int nthreads) {
        if (nthreads <= 0) {
            throw new IllegalArgumentException();
        }
        this.nthreads = nthreads;
        this.executorService = nthreads == 0 ? null : Executors.newFixedThreadPool(nthreads, new DaemonThreadFactory(GASEngine.class.getSimpleName()));
        this.schedulerClassRef = new AtomicReference();
        this.schedulerClassRef.set(CHMScheduler.class);
    }

    @Override
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    public void shutdownNow() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    protected Callable<Long> newFrontierStrategy(VertexTaskFactory<Long> taskFactory, IStaticFrontier f) {
        if (this.nthreads == 1) {
            return new RunInCallersThreadFrontierStrategy(taskFactory, f);
        }
        return new ParallelFrontierStrategy(taskFactory, f);
    }

    public ExecutorService getGASThreadPool() {
        if (this.executorService == null) {
            throw new UnsupportedOperationException();
        }
        return this.executorService;
    }

    public void setSchedulerClass(Class<IGASSchedulerImpl> newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        this.schedulerClassRef.set(newValue);
    }

    public Class<IGASSchedulerImpl> getSchedulerClass() {
        return this.schedulerClassRef.get();
    }

    public IStaticFrontier newStaticFrontier() {
        return new StaticFrontier2();
    }

    public IGASSchedulerImpl newScheduler() {
        Class<IGASSchedulerImpl> cls = this.schedulerClassRef.get();
        try {
            Constructor<IGASSchedulerImpl> ctor = cls.getConstructor(GASEngine.class);
            IGASSchedulerImpl sch = ctor.newInstance(this);
            return sch;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <VS, ES, ST> IGASContext<VS, ES, ST> newGASContext(IGraphAccessor graphAccessor, IGASProgram<VS, ES, ST> gasProgram) {
        IGASState<VS, ES, ST> gasState = this.newGASState(graphAccessor, gasProgram);
        return new GASContext<VS, ES, ST>(this, graphAccessor, gasState, gasProgram);
    }

    public <VS, ES, ST> IGASState<VS, ES, ST> newGASState(IGraphAccessor graphAccessor, IGASProgram<VS, ES, ST> gasProgram) {
        IStaticFrontier frontier = this.newStaticFrontier();
        IGASSchedulerImpl gasScheduler = this.newScheduler();
        return new GASState<VS, ES, ST>(this, graphAccessor, frontier, gasScheduler, gasProgram);
    }

    private class ParallelFrontierStrategy
    extends AbstractFrontierStrategy {
        private final IStaticFrontier f;
        private final HashSet<Value> scheduled;

        ParallelFrontierStrategy(VertexTaskFactory<Long> taskFactory, IStaticFrontier f) {
            super(taskFactory);
            this.f = f;
            this.scheduled = f.isCompact() ? null : new HashSet(f.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            LinkedList tasks = new LinkedList();
            long nedges = 0L;
            try {
                for (Value value : this.f) {
                    if (this.scheduled != null && !this.scheduled.add(value)) continue;
                    FutureTask ft = new FutureTask(this.taskFactory.newVertexTask(value));
                    tasks.add(ft);
                    GASEngine.this.executorService.execute(ft);
                }
                for (FutureTask futureTask : tasks) {
                    nedges += ((Long)futureTask.get()).longValue();
                }
            }
            finally {
                for (FutureTask futureTask : tasks) {
                    if (futureTask == null) continue;
                    futureTask.cancel(true);
                }
            }
            return nedges;
        }
    }

    private class RunInCallersThreadFrontierStrategy
    extends AbstractFrontierStrategy {
        private final IStaticFrontier f;

        RunInCallersThreadFrontierStrategy(VertexTaskFactory<Long> taskFactory, IStaticFrontier f) {
            super(taskFactory);
            this.f = f;
        }

        @Override
        public Long call() throws Exception {
            long nedges = 0L;
            for (Value u : this.f) {
                nedges += ((Long)this.taskFactory.newVertexTask(u).call()).longValue();
            }
            return nedges;
        }
    }

    private abstract class AbstractFrontierStrategy
    implements Callable<Long> {
        protected final VertexTaskFactory<Long> taskFactory;

        AbstractFrontierStrategy(VertexTaskFactory<Long> taskFactory) {
            this.taskFactory = taskFactory;
        }
    }
}

