/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.Tools;

final class Round<T extends Number>
extends AbstractField<T> {
    private static final long serialVersionUID = -7273879239726265322L;
    private final Field<T> argument;
    private final Field<Integer> decimals;

    Round(Field<T> argument) {
        this(argument, null);
    }

    Round(Field<T> argument, Field<Integer> decimals) {
        super(Names.N_ROUND, argument.getDataType());
        this.argument = argument;
        this.decimals = decimals;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                if (this.decimals == null) {
                    ctx.visit(DSL.when(Internal.isub(this.argument, DSL.floor(this.argument)).lessThan(0.5), DSL.floor(this.argument)).otherwise(DSL.ceil(this.argument)));
                    return;
                }
                if (this.decimals instanceof Param) {
                    Integer decimalsValue = (Integer)((Param)this.decimals).getValue();
                    Param<BigDecimal> factor = DSL.val(BigDecimal.ONE.movePointRight(decimalsValue));
                    Field<T> mul = Internal.imul(this.argument, factor);
                    ctx.visit(DSL.when(Internal.isub(mul, DSL.floor(mul)).lessThan(0.5), Internal.idiv(DSL.floor(mul), factor)).otherwise(Internal.idiv(DSL.ceil(mul), factor)));
                    return;
                }
            }
            case POSTGRES: {
                if (this.decimals == null) {
                    ctx.visit(DSL.function("round", this.getDataType(), this.argument));
                } else {
                    ctx.visit(DSL.function("round", this.getDataType(), Tools.castIfNeeded(this.argument, BigDecimal.class), this.decimals));
                }
                return;
            }
        }
        if (this.decimals == null) {
            ctx.visit(DSL.function("round", this.getDataType(), this.argument));
        } else {
            ctx.visit(DSL.function("round", this.getDataType(), this.argument, this.decimals));
        }
    }
}

