/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import java.util.Set;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONArrayAggOrderByStep;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractAggregateFunction;
import org.jooq.impl.CustomQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.JSONEntryImpl;
import org.jooq.impl.JSONNull;
import org.jooq.impl.Names;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Tools;

final class JSONArrayAgg<J>
extends AbstractAggregateFunction<J>
implements JSONArrayAggOrderByStep<J> {
    private static final long serialVersionUID = 1772007627336725780L;
    static final Set<SQLDialect> EMULATE_WITH_GROUP_CONCAT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private JSONNull.JSONNullType nullType;

    JSONArrayAgg(DataType<J> type, Field<?> arg) {
        super(false, Names.N_JSON_ARRAYAGG, type, arg);
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Names.N_JSON_MERGE).sql('(').visit(DSL.inline("[]")).sql(", ").visit(this.groupConcatEmulation(ctx)).sql(')');
                break;
            }
            case POSTGRES: {
                ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_AGG : Names.N_JSONB_AGG).sql('(');
                ctx.visit((QueryPart)this.arguments.get(0));
                this.acceptOrderBy(ctx);
                ctx.sql(')');
                if (this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL) {
                    JSONArrayAgg.acceptFilterClause(ctx, (this.filter == null ? DSL.noCondition() : this.filter).and(((Field)this.arguments.get(0)).isNotNull()));
                } else {
                    this.acceptFilterClause(ctx);
                }
                this.acceptOverClause(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private final Field<?> groupConcatEmulation(Context<?> ctx) {
        Field arg1 = (Field)this.arguments.get(0);
        if (arg1.getDataType().isString()) {
            switch (ctx.family()) {
                case MARIADB: 
                case MYSQL: {
                    arg1 = DSL.function(Names.N_JSON_QUOTE, this.getDataType(), arg1);
                }
            }
        }
        final Field arg2 = arg1;
        return DSL.concat(DSL.inline('['), DSL.field("{0}", SQLDataType.VARCHAR, new QueryPart[]{new CustomQueryPart(){

            @Override
            public void accept(Context<?> c1) {
                c1.visit(JSONArrayAgg.groupConcatEmulationWithoutArrayWrappers(DSL.field("{0}", SQLDataType.VARCHAR, new QueryPart[]{new CustomQueryPart(){

                    @Override
                    public void accept(Context<?> c2) {
                        JSONArrayAgg.this.acceptArguments2(c2, QueryPartListView.wrap((QueryPart[])new Field[]{arg2}));
                    }
                }}), JSONArrayAgg.this.withinGroupOrderBy));
                JSONArrayAgg.this.acceptFilterClause(c1);
                JSONArrayAgg.this.acceptOverClause(c1);
            }
        }}), DSL.inline(']'));
    }

    static final Field<?> groupConcatEmulationWithoutArrayWrappers(Field<?> field, SortFieldList orderBy) {
        return Tools.isEmpty(orderBy) ? DSL.groupConcat(field) : DSL.groupConcat(field).orderBy(orderBy);
    }

    private final void acceptStandard(Context<?> ctx) {
        ctx.visit(Names.N_JSON_ARRAYAGG).sql('(');
        ctx.visit(JSONEntryImpl.jsonCast(ctx, (Field)this.arguments.get(0)));
        this.acceptOrderBy(ctx);
        JSONNull jsonNull = new JSONNull(this.nullType);
        if (jsonNull.rendersContent(ctx)) {
            ctx.sql(' ').visit(jsonNull);
        }
        ctx.sql(')');
        this.acceptFilterClause(ctx);
        this.acceptOverClause(ctx);
    }

    @Override
    public final JSONArrayAgg<J> nullOnNull() {
        this.nullType = JSONNull.JSONNullType.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONArrayAgg<J> absentOnNull() {
        this.nullType = JSONNull.JSONNullType.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONArrayAgg<J> orderBy(OrderField<?> ... fields) {
        return (JSONArrayAgg)super.orderBy((OrderField[])fields);
    }

    @Override
    public final JSONArrayAgg<J> orderBy(Collection<? extends OrderField<?>> fields) {
        return (JSONArrayAgg)super.orderBy((Collection)fields);
    }
}

