/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONArrayNullStep;
import org.jooq.QueryPart;
import org.jooq.Row1;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.F1;
import org.jooq.impl.JSONEntryImpl;
import org.jooq.impl.JSONNull;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SQLDataType;

final class JSONArray<J>
extends AbstractField<J>
implements JSONArrayNullStep<J> {
    private static final long serialVersionUID = 1772007627336725780L;
    private final QueryPartList<Field<?>> args;
    private final JSONNull.JSONNullType nullType;

    JSONArray(DataType<J> type, Collection<? extends Field<?>> args) {
        this(type, args, null);
    }

    JSONArray(DataType<J> type, Collection<? extends Field<?>> args, JSONNull.JSONNullType nullType) {
        super(Names.N_JSON_ARRAY, type);
        this.args = new QueryPartList((Iterable<Field<?>>)args);
        this.nullType = nullType;
    }

    @Override
    public final JSONArray<J> nullOnNull() {
        return new JSONArray(this.getDataType(), this.args, JSONNull.JSONNullType.NULL_ON_NULL);
    }

    @Override
    public final JSONArray<J> absentOnNull() {
        return new JSONArray(this.getDataType(), this.args, JSONNull.JSONNullType.ABSENT_ON_NULL);
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                if (this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL) {
                    Row1[] rows = new Row1[this.args.size()];
                    for (int i = 0; i < rows.length; ++i) {
                        rows[i] = DSL.row((Field)this.args.get(i));
                    }
                    Table t = DSL.values(rows).as("t", "a");
                    Field<?> a = t.field("a");
                    ctx.visit(DSL.field(DSL.select(this.getDataType() == SQLDataType.JSON ? DSL.jsonArrayAgg(a) : DSL.jsonbArrayAgg(a)).from((TableLike<?>)t).where(a.isNotNull())));
                    break;
                }
                ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_BUILD_ARRAY : Names.N_JSONB_BUILD_ARRAY).sql('(').visit(this.args).sql(')');
                break;
            }
            default: {
                JSONNull jsonNull = ctx.family() == SQLDialect.H2 && this.args.isEmpty() ? new JSONNull(JSONNull.JSONNullType.NULL_ON_NULL) : new JSONNull(this.nullType);
                ctx.visit(Keywords.K_JSON_ARRAY).sql('(').visit(QueryPartListView.wrap((QueryPart[])new AbstractQueryPart[]{QueryPartListView.wrap(this.args).map((F1)JSONEntryImpl.jsonCastMapper(ctx)), jsonNull}).separator("")).sql(')');
                break;
            }
        }
    }
}

