/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.RecordImpl1;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class GenerateSeries
extends AbstractTable<Record1<Integer>> {
    private static final long serialVersionUID = 2385574114457239818L;
    private final Field<Integer> from;
    private final Field<Integer> to;
    private final Field<Integer> step;

    GenerateSeries(Field<Integer> from, Field<Integer> to) {
        this(from, to, null);
    }

    GenerateSeries(Field<Integer> from, Field<Integer> to, Field<Integer> step) {
        super(TableOptions.expression(), Names.N_GENERATE_SERIES);
        this.from = from;
        this.to = to;
        this.step = step;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case HSQLDB: 
            case SQLITE: 
            case MARIADB: 
            case MYSQL: {
                Name v = DSL.unquotedName("v");
                Field<Integer> f = DSL.field(v, SQLDataType.INTEGER);
                Tools.visitSubquery(ctx, DSL.withRecursive(Names.N_GENERATE_SERIES, v).as(DSL.select(this.from).unionAll((Select)DSL.select(Internal.iadd(f, this.step == null ? DSL.inline(1) : this.step)).from(Names.N_GENERATE_SERIES).where(f.lt(this.to)))).select(f.as(Names.N_GENERATE_SERIES)).from(Names.N_GENERATE_SERIES), true);
                break;
            }
            case H2: {
                if (this.step == null) {
                    ctx.visit(Names.N_SYSTEM_RANGE).sql('(').visit(this.from).sql(", ").visit(this.to).sql(')');
                    break;
                }
                ctx.visit(Names.N_SYSTEM_RANGE).sql('(').visit(this.from).sql(", ").visit(this.to).sql(", ").visit(this.step).sql(')');
                break;
            }
            default: {
                if (this.step == null) {
                    ctx.visit(Names.N_GENERATE_SERIES).sql('(').visit(this.from).sql(", ").visit(this.to).sql(')');
                    break;
                }
                ctx.visit(Names.N_GENERATE_SERIES).sql('(').visit(this.from).sql(", ").visit(this.to).sql(", ").visit(this.step).sql(')');
            }
        }
    }

    @Override
    public final Class<? extends Record1<Integer>> getRecordType() {
        return RecordImpl1.class;
    }

    @Override
    final Fields<Record1<Integer>> fields0() {
        return new Fields<Record1<Integer>>(DSL.field(Names.N_GENERATE_SERIES, Integer.class));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

