/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class NumericLiteralImpl
extends LiteralImpl {
    private static final long serialVersionUID = 3004497457768807919L;
    private final Number number;

    public NumericLiteralImpl(Number number, URI datatype) {
        super(number.toString(), datatype);
        this.number = number;
    }

    public NumericLiteralImpl(byte number) {
        this(number, XMLSchema.BYTE);
    }

    public NumericLiteralImpl(short number) {
        this(number, XMLSchema.SHORT);
    }

    public NumericLiteralImpl(int number) {
        this(number, XMLSchema.INT);
    }

    public NumericLiteralImpl(long n) {
        this(n, XMLSchema.LONG);
    }

    public NumericLiteralImpl(float n) {
        this(Float.valueOf(n), XMLSchema.FLOAT);
    }

    public NumericLiteralImpl(double n) {
        this(n, XMLSchema.DOUBLE);
    }

    @Override
    public byte byteValue() {
        return this.number.byteValue();
    }

    @Override
    public short shortValue() {
        return this.number.shortValue();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }
}

