/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONArraySerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectSerializer
extends JSONBaseSerializer<JSONObject> {
    public static final JSONObjectSerializer instance = new JSONObjectSerializer();

    public JSONObjectSerializer() {
        super(JSONObject.class);
    }

    public void serialize(JSONObject jSONObject, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartObject();
        this.serializeContents(jSONObject, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndObject();
    }

    public void serializeWithType(JSONObject jSONObject, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForObject((Object)jSONObject, jsonGenerator);
        this.serializeContents(jSONObject, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForObject((Object)jSONObject, jsonGenerator);
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    protected void serializeContents(JSONObject jSONObject, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            try {
                object = jSONObject.get(string);
            }
            catch (JSONException jSONException) {
                throw new JsonGenerationException((Throwable)jSONException);
            }
            if (object == null || object == JSONObject.NULL) {
                if (!serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) continue;
                jsonGenerator.writeNullField(string);
                continue;
            }
            jsonGenerator.writeFieldName(string);
            Class<?> clazz = object.getClass();
            if (clazz == JSONObject.class) {
                this.serialize((JSONObject)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (clazz == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (clazz == String.class) {
                jsonGenerator.writeString((String)object);
                continue;
            }
            if (clazz == Integer.class) {
                jsonGenerator.writeNumber(((Integer)object).intValue());
                continue;
            }
            if (clazz == Long.class) {
                jsonGenerator.writeNumber(((Long)object).longValue());
                continue;
            }
            if (clazz == Boolean.class) {
                jsonGenerator.writeBoolean(((Boolean)object).booleanValue());
                continue;
            }
            if (clazz == Double.class) {
                jsonGenerator.writeNumber(((Double)object).doubleValue());
                continue;
            }
            if (clazz == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(clazz)) {
                this.serialize((JSONObject)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(clazz)) {
                JSONArraySerializer.instance.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            serializerProvider.defaultSerializeValue(object, jsonGenerator);
        }
    }
}

