/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONArrayDeserializer;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectDeserializer
extends StdDeserializer<JSONObject> {
    private static final long serialVersionUID = 1L;
    public static final JSONObjectDeserializer instance = new JSONObjectDeserializer();

    public JSONObjectDeserializer() {
        super(JSONObject.class);
    }

    public JSONObject deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JSONObject jSONObject = new JSONObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        while (jsonToken == JsonToken.FIELD_NAME) {
            block15: {
                String string = jsonParser.getCurrentName();
                jsonToken = jsonParser.nextToken();
                try {
                    switch (jsonToken) {
                        case START_ARRAY: {
                            jSONObject.put(string, (Object)JSONArrayDeserializer.instance.deserialize(jsonParser, deserializationContext));
                            break block15;
                        }
                        case START_OBJECT: {
                            jSONObject.put(string, (Object)this.deserialize(jsonParser, deserializationContext));
                            break block15;
                        }
                        case VALUE_STRING: {
                            jSONObject.put(string, (Object)jsonParser.getText());
                            break block15;
                        }
                        case VALUE_NULL: {
                            jSONObject.put(string, JSONObject.NULL);
                            break block15;
                        }
                        case VALUE_TRUE: {
                            jSONObject.put(string, (Object)Boolean.TRUE);
                            break block15;
                        }
                        case VALUE_FALSE: {
                            jSONObject.put(string, (Object)Boolean.FALSE);
                            break block15;
                        }
                        case VALUE_NUMBER_INT: {
                            jSONObject.put(string, (Object)jsonParser.getNumberValue());
                            break block15;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            jSONObject.put(string, (Object)jsonParser.getNumberValue());
                            break block15;
                        }
                        case VALUE_EMBEDDED_OBJECT: {
                            jSONObject.put(string, jsonParser.getEmbeddedObject());
                            break block15;
                        }
                    }
                }
                catch (JSONException jSONException) {
                    throw deserializationContext.mappingException("Failed to construct JSONObject: " + jSONException.getMessage());
                }
                throw deserializationContext.mappingException("Urecognized or unsupported JsonToken type: " + jsonToken);
            }
            jsonToken = jsonParser.nextToken();
        }
        return jSONObject;
    }
}

