/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.op.projection.UniversalTransverseMercator;
import org.cts.units.Measure;
import org.cts.util.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransverseMercator
extends Projection {
    public static final Identifier TMERC = new Identifier("EPSG", "9807", "Transverse Mercator", "TMERC");
    protected final double lat0;
    protected final double lon0;
    protected final double n;
    protected final double xs;
    protected final double ys;
    protected final double[] dircoeff;
    protected final double[] invcoeff;

    public TransverseMercator(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(TMERC, ellipsoid, parameters);
        double k0 = this.getScaleFactor();
        double x0 = this.getFalseEasting();
        double y0 = this.getFalseNorthing();
        this.lon0 = this.getCentralMeridian();
        this.lat0 = this.getLatitudeOfOrigin();
        this.n = k0 * ellipsoid.getSemiMajorAxis();
        this.xs = x0;
        this.ys = y0 - this.n * ellipsoid.curvilinearAbscissa(this.lat0);
        this.dircoeff = UniversalTransverseMercator.getDirectUTMCoeff(ellipsoid);
        this.invcoeff = UniversalTransverseMercator.getInverseUTMCoeff(ellipsoid);
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double latIsoPhi = this.ellipsoid.isometricLatitude(coord[0]);
        double PHI = Math.asin(Math.sin(coord[1] - this.lon0) / Math.cosh(latIsoPhi));
        double latIsoPHI = Ellipsoid.SPHERE.isometricLatitude(PHI);
        double lambda = Math.atan(Math.sinh(latIsoPhi) / Math.cos(coord[1] - this.lon0));
        Complex z = new Complex(lambda, latIsoPHI);
        Complex Z = z.times(this.n * this.dircoeff[0]);
        for (int i = 1; i < 5; ++i) {
            Z = Z.plus(Complex.sin(z.times(2.0 * (double)i)).times(this.n * this.dircoeff[i]));
        }
        coord[0] = this.xs + Z.im();
        coord[1] = this.ys + Z.re();
        return coord;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new TransverseMercator(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double lat;
                Complex z;
                Complex Z = z = new Complex((coord[1] - this.ys) / (this.n * this.invcoeff[0]), (coord[0] - this.xs) / (this.n * this.invcoeff[0]));
                for (int i = 1; i < 5; ++i) {
                    Z = Z.plus(Complex.sin(z.times(2.0 * (double)i)).times(-this.invcoeff[i]));
                }
                double lon = this.lon0 + Math.atan(Math.sinh(Z.im()) / Math.cos(Z.re()));
                double PHI = Math.asin(Math.sin(Z.re()) / Math.cosh(Z.im()));
                double latIso = Ellipsoid.SPHERE.isometricLatitude(PHI);
                coord[0] = lat = this.ellipsoid.latitude(latIso);
                coord[1] = lon;
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return TransverseMercator.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return TransverseMercator.this.toString() + " inverse";
            }
        };
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TRANSVERSE;
    }
}

