/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;

public class LoadMemorizeCoordinate
extends AbstractCoordinateOperation {
    private final int indexSaved;
    public static CoordinateOperation loadX = new LoadMemorizeCoordinate(0);
    public static CoordinateOperation loadY = new LoadMemorizeCoordinate(1);
    public static CoordinateOperation loadZ = new LoadMemorizeCoordinate(2);

    public LoadMemorizeCoordinate(int index) {
        super(new Identifier(CoordinateOperation.class, "Load last saved coordinate in position " + index));
        this.indexSaved = index;
    }

    public int getIndexSaved() {
        return this.indexSaved;
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 4) {
            throw new IllegalCoordinateException("There is no saved value in these coordinates.");
        }
        double[] cc = new double[coord.length - 1];
        System.arraycopy(coord, 0, cc, 0, coord.length - 1);
        cc[this.indexSaved] = coord[coord.length - 1];
        return cc;
    }
}

