/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;

public class CoordinateSwitch
extends AbstractCoordinateOperation {
    public static final CoordinateSwitch SWITCH_LAT_LON = new CoordinateSwitch(0, 1);
    int pos1;
    int pos2;

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < Math.min(this.pos1, this.pos2)) {
            throw new CoordinateDimensionException(coord, Math.max(this.pos1, this.pos2));
        }
        double d1 = coord[this.pos1];
        coord[this.pos1] = coord[this.pos2];
        coord[this.pos2] = d1;
        return coord;
    }

    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return this;
    }

    public CoordinateSwitch(int pos1, int pos2) {
        super(new Identifier(CoordinateOperation.class, "Coordinates switch"));
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && o instanceof CoordinateSwitch && this.pos1 == ((CoordinateSwitch)o).pos1 && this.pos2 == ((CoordinateSwitch)o).pos2;
    }
}

