/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.ChangeCoordinateDimension;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.Identity;
import org.cts.op.NonInvertibleOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateOperationSequence
extends AbstractCoordinateOperation {
    protected CoordinateOperation[] sequence;

    public CoordinateOperationSequence(Identifier identifier, CoordinateOperation ... sequence) {
        super(identifier);
        this.sequence = sequence;
        this.sequence = CoordinateOperationSequence.cleanSequence(sequence);
        for (CoordinateOperation op : sequence) {
            this.precision += op.getPrecision();
        }
    }

    public CoordinateOperationSequence(Identifier identifier, List<CoordinateOperation> list) {
        super(identifier);
        this.sequence = list.toArray(new CoordinateOperation[list.size()]);
        for (CoordinateOperation op : this.sequence = CoordinateOperationSequence.cleanSequence(this.sequence)) {
            this.precision += op.getPrecision();
        }
    }

    public CoordinateOperationSequence(Identifier identifier, CoordinateOperation[] sequence, double precision) {
        super(identifier);
        this.sequence = sequence;
        this.sequence = CoordinateOperationSequence.cleanSequence(sequence);
        this.precision = precision;
    }

    public CoordinateOperationSequence(Identifier identifier, List<CoordinateOperation> list, double precision) {
        super(identifier);
        this.sequence = list.toArray(new CoordinateOperation[list.size()]);
        this.sequence = CoordinateOperationSequence.cleanSequence(this.sequence);
        this.precision = precision;
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException, CoordinateOperationException {
        for (CoordinateOperation op : this.sequence) {
            coord = op.transform(coord);
        }
        return coord;
    }

    @Override
    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        CoordinateOperation[] inverse_sequence = new CoordinateOperation[this.sequence.length];
        for (int i = 0; i < this.sequence.length; ++i) {
            inverse_sequence[this.sequence.length - i - 1] = this.sequence[i].inverse();
        }
        return new CoordinateOperationSequence(this.getIdentifier(), inverse_sequence, this.precision);
    }

    @Override
    public double getPrecision() {
        double combinedPrecision = 0.0;
        for (CoordinateOperation op : this.sequence) {
            combinedPrecision += op.getPrecision();
        }
        return combinedPrecision;
    }

    CoordinateOperation[] getSequence() {
        return this.sequence;
    }

    private static List<CoordinateOperation> fusionSequences(List<CoordinateOperation> list1, List<CoordinateOperation> list2) {
        ArrayList<CoordinateOperation> lst1 = new ArrayList<CoordinateOperation>(list1);
        ArrayList<CoordinateOperation> lst2 = new ArrayList<CoordinateOperation>(list2);
        if (lst1.isEmpty() && lst2.isEmpty()) {
            lst1.add(Identity.IDENTITY);
            return lst1;
        }
        if (lst1.isEmpty()) {
            return lst2;
        }
        if (lst2.isEmpty()) {
            return lst1;
        }
        CoordinateOperation op1 = (CoordinateOperation)lst1.get(lst1.size() - 1);
        CoordinateOperation op2 = (CoordinateOperation)lst2.get(0);
        if (op1.equals(Identity.IDENTITY)) {
            lst1.remove(lst1.size() - 1);
            return CoordinateOperationSequence.fusionSequences(lst1, lst2);
        }
        if (op2.equals(Identity.IDENTITY)) {
            lst2.remove(0);
            return CoordinateOperationSequence.fusionSequences(lst1, lst2);
        }
        try {
            if (op1.equals(ChangeCoordinateDimension.TO3D) && op2.equals(ChangeCoordinateDimension.TO2D) || op1.equals(op2.inverse())) {
                lst1.remove(lst1.size() - 1);
                lst2.remove(0);
                return CoordinateOperationSequence.fusionSequences(lst1, lst2);
            }
        }
        catch (NonInvertibleOperationException nonInvertibleOperationException) {
            // empty catch block
        }
        lst1.addAll(lst2);
        return lst1;
    }

    private static CoordinateOperation[] cleanSequence(CoordinateOperation ... sequence) {
        List<CoordinateOperation> result = new ArrayList<CoordinateOperation>();
        for (CoordinateOperation op : sequence) {
            if (op != null && !op.isIdentity() && !(op instanceof CoordinateOperationSequence)) {
                result.add(op);
                continue;
            }
            if (!(op instanceof CoordinateOperationSequence)) continue;
            result = CoordinateOperationSequence.fusionSequences(result, Arrays.asList(((CoordinateOperationSequence)op).getSequence()));
        }
        for (int i = result.size() - 1; i > 0; --i) {
            CoordinateOperation op = (CoordinateOperation)result.get(i);
            try {
                if (!op.inverse().equals(result.get(i - 1))) continue;
                result.remove(i);
                result.remove(i - 1);
                i -= 2;
                continue;
            }
            catch (NonInvertibleOperationException nonInvertibleOperationException) {
                // empty catch block
            }
        }
        if (sequence.length > 0 && result.isEmpty()) {
            result.add(Identity.IDENTITY);
        }
        return result.toArray(new CoordinateOperation[result.size()]);
    }

    public static List<CoordinateOperation> cleverAdd(List<CoordinateOperation> ops, CoordinateOperation op) {
        List<CoordinateOperation> result = new ArrayList<CoordinateOperation>(ops);
        ArrayList<CoordinateOperation> addedOp = new ArrayList<CoordinateOperation>();
        addedOp.add(op);
        result = CoordinateOperationSequence.fusionSequences(result, addedOp);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.getIdentifier().getName()).append("{");
        for (CoordinateOperation op : this.sequence) {
            sb.append("\n   ").append(op.toString());
        }
        sb.append("\n} precision = " + this.getPrecision());
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CoordinateOperationSequence) {
            CoordinateOperationSequence cooordseq = (CoordinateOperationSequence)o;
            if (this.getSequence().length == cooordseq.getSequence().length) {
                for (int i = 0; i < this.getSequence().length; ++i) {
                    if (this.getSequence()[i].equals(cooordseq.getSequence()[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Arrays.deepHashCode(this.sequence);
        return hash;
    }

    @Override
    public boolean isIdentity() {
        for (CoordinateOperation op : this.sequence) {
            if (op.isIdentity()) continue;
            return false;
        }
        return true;
    }
}

