/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrefixHashSet {
    private int length = Integer.MAX_VALUE;
    private final Map<String, List<String>> index = new HashMap<String, List<String>>();

    public PrefixHashSet(Iterable<String> values) {
        for (String value : values) {
            if (value.length() >= this.length) continue;
            this.length = value.length();
        }
        for (String value : values) {
            String key = value.substring(0, this.length);
            List<String> entry = this.index.get(key);
            if (entry == null) {
                entry = new ArrayList<String>();
                this.index.put(key, entry);
            }
            entry.add(value.substring(this.length));
        }
    }

    public boolean match(String value) {
        String key;
        List<String> entry;
        boolean result = false;
        if (value.length() >= this.length && (entry = this.index.get(key = value.substring(0, this.length))) != null) {
            result = this.matchValueToEntry(value, entry);
        }
        return result;
    }

    private boolean matchValueToEntry(String value, List<String> entry) {
        boolean result = false;
        String tail = value.substring(this.length);
        for (String prefix : entry) {
            if (!tail.startsWith(prefix)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String toString() {
        return this.index.toString();
    }
}

