/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.PrefixMapping;

public abstract class PrefixMapBase
implements PrefixMap {
    protected boolean strSafeFor(String str2, char ch) {
        return str2.indexOf(ch) == -1;
    }

    protected String canonicalPrefix(String prefix) {
        if (prefix.endsWith(":")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    @Override
    public Map<String, String> getMappingCopy() {
        return new HashMap<String, String>(this.getMapping());
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        this.getMapping().forEach(action);
    }

    @Override
    public void putAll(PrefixMap pmap) {
        pmap.getMapping().forEach(this::add);
    }

    @Override
    public void putAll(PrefixMapping pmap) {
        this.putAll(pmap.getNsPrefixMap());
    }

    @Override
    public void putAll(Map<String, String> mapping) {
        mapping.forEach(this::add);
    }

    protected Pair<String, String> abbrev(Map<String, String> prefixes, String uriStr, boolean checkLocalPart) {
        for (Map.Entry<String, String> e2 : prefixes.entrySet()) {
            String uriForPrefix = e2.getValue();
            if (!uriStr.startsWith(uriForPrefix)) continue;
            String ln2 = uriStr.substring(uriForPrefix.length());
            if (checkLocalPart && !this.isSafeLocalPart(ln2)) continue;
            return Pair.create((Object)e2.getKey(), (Object)ln2);
        }
        return null;
    }

    @Override
    public String expand(String prefixedName) {
        int i = prefixedName.indexOf(58);
        if (i < 0) {
            return null;
        }
        return this.expand(prefixedName.substring(0, i), prefixedName.substring(i + 1));
    }

    protected boolean isSafeLocalPart(String ln2) {
        return this.strSafeFor(ln2, '/') && this.strSafeFor(ln2, '#');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, String> e2 : this.getMapping().entrySet()) {
            String prefix = e2.getKey();
            String iri = e2.getValue();
            if (first) {
                first = false;
            } else {
                sb.append(" ,");
            }
            sb.append(prefix);
            sb.append(":=");
            sb.append(iri);
        }
        sb.append(" }");
        return sb.toString();
    }
}

