/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.proxy;

import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.service.proxy.RemoteAsynchronousIterator;
import com.bigdata.util.DaemonThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ClientAsynchronousIterator<E>
implements IAsynchronousIterator<E>,
Serializable {
    private static final long serialVersionUID = -6809878299983373766L;
    protected static final transient Logger log = Logger.getLogger(ClientAsynchronousIterator.class);
    protected static final transient boolean INFO = log.isInfoEnabled();
    protected static final transient boolean DEBUG = log.isDebugEnabled();
    private final RemoteAsynchronousIterator<E> remoteIterator;
    private final int capacity;
    private transient BlockingBuffer<E> localBuffer;
    private transient Future<Void> future;
    private transient IAsynchronousIterator<E> localIterator;
    private transient ExecutorService executorService;
    protected static final transient long timeout = 1L;
    protected static final transient TimeUnit unit = TimeUnit.MILLISECONDS;
    protected static final transient boolean trace = false;

    public ClientAsynchronousIterator(RemoteAsynchronousIterator<E> remoteIterator, int capacity) {
        if (remoteIterator == null) {
            throw new IllegalArgumentException();
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.remoteIterator = remoteIterator;
        this.capacity = capacity;
    }

    public void start(ExecutorService executorService) {
        if (executorService == null) {
            throw new IllegalArgumentException();
        }
        if (this.future != null) {
            throw new IllegalStateException();
        }
        this.localBuffer = new BlockingBuffer(this.capacity);
        FutureTask<Void> ft = new FutureTask<Void>(new ReaderTask());
        this.future = ft;
        this.localBuffer.setFuture(this.future);
        this.localIterator = this.localBuffer.iterator();
        executorService.submit(ft);
    }

    protected final void start() {
        if (this.future != null) {
            return;
        }
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory(this.getClass().getName() + ".executorService"));
        this.start(this.executorService);
        log.warn((Object)"Running reader on private executor service");
    }

    @Override
    public void close() {
        if (this.future == null) {
            try {
                this.remoteIterator.close();
            }
            catch (IOException ex) {
                log.warn((Object)ex);
            }
            return;
        }
        this.localBuffer.close();
        if (!this.future.isDone()) {
            this.future.cancel(true);
        }
        this.localIterator.close();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    public boolean hasNext(long timeout, TimeUnit unit) throws InterruptedException {
        this.start();
        return this.localIterator.hasNext(timeout, unit);
    }

    @Override
    public boolean isExhausted() {
        this.start();
        return this.localIterator.isExhausted();
    }

    @Override
    public E next(long timeout, TimeUnit unit) throws InterruptedException {
        this.start();
        return this.localIterator.next(timeout, unit);
    }

    public boolean hasNext() {
        this.start();
        return this.localIterator.hasNext();
    }

    public E next() {
        this.start();
        return (E)this.localIterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class ReaderTask
    implements Callable<Void> {
        private ReaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            boolean interrupted = false;
            try {
                while (true) {
                    if (!ClientAsynchronousIterator.this.remoteIterator.hasNext(1L, unit)) {
                        if (Thread.interrupted()) {
                            interrupted = true;
                            break;
                        }
                        if (!ClientAsynchronousIterator.this.remoteIterator.isExhausted() && ClientAsynchronousIterator.this.localBuffer.isOpen()) continue;
                        break;
                    }
                    if (Thread.interrupted()) {
                        interrupted = true;
                        break;
                    }
                    Object e = ClientAsynchronousIterator.this.remoteIterator.nextElement().get();
                    try {
                        ClientAsynchronousIterator.this.localBuffer.add(e);
                    }
                    catch (BufferClosedException ex) {
                        if (!INFO) break;
                        log.info((Object)ex.getLocalizedMessage());
                        break;
                    }
                }
                if (INFO) {
                    log.info((Object)("Reader is done: interrupted" + interrupted));
                }
                Void void_ = null;
                return void_;
            }
            finally {
                ClientAsynchronousIterator.this.localBuffer.close();
                try {
                    ClientAsynchronousIterator.this.remoteIterator.close();
                }
                catch (Throwable ex) {
                    log.warn((Object)ex.getLocalizedMessage());
                }
                if (ClientAsynchronousIterator.this.executorService != null) {
                    ClientAsynchronousIterator.this.executorService.shutdown();
                }
            }
        }
    }
}

