/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.proc.IIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.resources.StaleLocatorException;
import com.bigdata.service.DataService;
import com.bigdata.service.IDataService;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.service.ndx.IndexSyncRPCCounters;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.TaskCounters;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

abstract class AbstractDataServiceProcedureTask
implements Callable<Void> {
    protected static final transient Logger log = Logger.getLogger(AbstractDataServiceProcedureTask.class);
    protected final boolean WARN = log.getEffectiveLevel().toInt() <= Level.WARN.toInt();
    protected final IScaleOutClientIndex ndx;
    protected final long ts;
    protected final Split split;
    protected final IIndexProcedure proc;
    protected final IResultHandler resultHandler;
    private final TaskCounters taskCounters;
    protected final IndexSyncRPCCounters taskCountersByIndex;
    private long nanoTime_submitTask;
    private long nanoTime_beginWork;
    private long nanoTime_finishedWork;
    protected List<Throwable> causes = null;

    public String toString() {
        return "index=" + this.ndx.getName() + ", ts=" + this.ts + ", procedure " + this.proc.getClass().getName() + " : " + this.split;
    }

    protected abstract int getElementCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractDataServiceProcedureTask(IScaleOutClientIndex ndx, long ts, Split split, IIndexProcedure proc, IResultHandler resultHandler) {
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        if (split.pmd == null) {
            throw new IllegalArgumentException();
        }
        if (!(split.pmd instanceof PartitionLocator)) {
            throw new IllegalArgumentException("Split does not have a locator");
        }
        if (proc == null) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
        this.ts = ts;
        this.split = split;
        this.proc = proc;
        this.resultHandler = resultHandler;
        this.taskCounters = ndx.getFederation().getTaskCounters();
        this.taskCountersByIndex = ndx.getFederation().getIndexCounters((String)ndx.getName()).synchronousCounters;
        this.nanoTime_submitTask = System.nanoTime();
        if (proc.isReadOnly()) {
            IndexSyncRPCCounters indexSyncRPCCounters = this.taskCountersByIndex;
            synchronized (indexSyncRPCCounters) {
                ++this.taskCountersByIndex.readOnlyRequestCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Void call() throws Exception {
        PartitionLocator locator = (PartitionLocator)this.split.pmd;
        AtomicLong atomicLong = this.taskCounters.lastArrivalNanoTime;
        synchronized (atomicLong) {
            long lastArrivalNanoTime = this.taskCounters.lastArrivalNanoTime.get();
            long now = System.nanoTime();
            long delta = now - lastArrivalNanoTime;
            this.taskCounters.interArrivalNanoTime.addAndGet(delta);
            this.taskCounters.lastArrivalNanoTime.set(now);
        }
        this.taskCounters.taskSubmitCount.incrementAndGet();
        this.taskCountersByIndex.taskSubmitCount.incrementAndGet();
        this.nanoTime_beginWork = System.nanoTime();
        long queueWaitingTime = this.nanoTime_beginWork - this.nanoTime_submitTask;
        this.taskCounters.queueWaitingNanoTime.addAndGet(queueWaitingTime);
        this.taskCountersByIndex.queueWaitingNanoTime.addAndGet(queueWaitingTime);
        IndexSyncRPCCounters indexSyncRPCCounters = this.taskCountersByIndex;
        synchronized (indexSyncRPCCounters) {
            this.taskCountersByIndex.elementsOut += (long)this.getElementCount();
            ++this.taskCountersByIndex.requestCount;
        }
        try {
            this.submit(locator);
            this.taskCounters.taskSuccessCount.incrementAndGet();
            this.taskCountersByIndex.taskSuccessCount.incrementAndGet();
        }
        catch (Exception ex) {
            this.taskCounters.taskFailCount.incrementAndGet();
            this.taskCountersByIndex.taskFailCount.incrementAndGet();
            throw ex;
        }
        finally {
            this.nanoTime_finishedWork = System.nanoTime();
            this.taskCounters.taskCompleteCount.incrementAndGet();
            this.taskCountersByIndex.taskCompleteCount.incrementAndGet();
            long serviceNanoTime = this.nanoTime_finishedWork - this.nanoTime_beginWork;
            this.taskCounters.serviceNanoTime.addAndGet(serviceNanoTime);
            this.taskCountersByIndex.serviceNanoTime.addAndGet(serviceNanoTime);
            long queuingNanoTime = this.nanoTime_finishedWork - this.nanoTime_submitTask;
            this.taskCounters.queuingNanoTime.addAndGet(queuingNanoTime);
            this.taskCountersByIndex.queuingNanoTime.addAndGet(queuingNanoTime);
        }
        return null;
    }

    protected final void submit(PartitionLocator locator) throws Exception {
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        IDataService dataService = this.ndx.getDataService(locator);
        if (dataService == null) {
            throw new RuntimeException("DataService not found: " + locator);
        }
        String name = DataService.getIndexPartitionName(this.ndx.getName(), this.split.pmd.getPartitionId());
        if (log.isInfoEnabled()) {
            log.info((Object)("Submitting task=" + this + " on " + dataService));
        }
        try {
            this.submit(dataService, name);
        }
        catch (Exception ex) {
            if (this.causes == null) {
                this.causes = new LinkedList<Throwable>();
            }
            this.causes.add(ex);
            StaleLocatorException cause = (StaleLocatorException)InnerCause.getInnerCause((Throwable)ex, StaleLocatorException.class);
            if (cause != null) {
                this.ndx.staleLocator(this.ts, locator, cause);
                this.retry();
            }
            throw ex;
        }
    }

    private final void submit(IDataService dataService, String name) throws Exception {
        Object result = dataService.submit(this.ts, name, this.proc).get();
        if (this.resultHandler != null) {
            this.resultHandler.aggregate(result, this.split);
        }
    }

    protected abstract void retry() throws Exception;
}

