/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.service.ITxState;
import com.bigdata.service.ITxState0;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class TxId2CommitTimeIndex
extends BTree {
    private final IKeyBuilder keyBuilder = new KeyBuilder(8);

    public static TxId2CommitTimeIndex createTransient() {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(TxId2CommitTimeIndex.class.getName());
        metadata.setTupleSerializer(new TupleSerializer(new ASCIIKeyBuilderFactory(16)));
        return (TxId2CommitTimeIndex)BTree.createTransient(metadata);
    }

    public TxId2CommitTimeIndex(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
    }

    private byte[] encodeKey(long startTime) {
        long tmp = Math.abs(startTime);
        return this.keyBuilder.reset().append(tmp).getKey();
    }

    private static final long decodeKey(byte[] key) {
        return KeyBuilder.decodeLong(key, 0);
    }

    public synchronized long find(long timestamp) {
        if (timestamp <= 0L) {
            throw new IllegalArgumentException();
        }
        long index = this.findIndexOf(timestamp);
        if (index == -1L) {
            return -1L;
        }
        return TxId2CommitTimeIndex.decodeKey(this.keyAt(index));
    }

    public synchronized long findNext(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException();
        }
        long index = this.findIndexOf(Math.abs(timestamp)) + 1L;
        if (index == this.nentries) {
            return -1L;
        }
        return TxId2CommitTimeIndex.decodeKey(this.keyAt(index));
    }

    public synchronized long findIndexOf(long timestamp) {
        long pos = super.indexOf(this.encodeKey(timestamp));
        if (pos < 0L) {
            if ((pos = -(pos + 1L)) == 0L) {
                return -1L;
            }
            return --pos;
        }
        return pos;
    }

    public void add(AbstractTransactionService.TxState txState) {
        if (txState == null) {
            throw new IllegalArgumentException();
        }
        if (txState.tx == 0L) {
            throw new IllegalArgumentException();
        }
        if (txState.getReadsOnCommitTime() < 0L) {
            throw new IllegalArgumentException();
        }
        TupleSerializer tupleSer = (TupleSerializer)this.getIndexMetadata().getTupleSerializer();
        byte[] key = tupleSer.serializeKey(txState);
        if (super.contains(key)) {
            throw new IllegalArgumentException("entry exists: key=" + key + ", newValue=" + txState);
        }
        byte[] val = tupleSer.serializeVal(txState);
        super.insert(key, val);
    }

    protected static class TupleSerializer
    extends DefaultTupleSerializer<Long, ITxState0> {
        private static final long serialVersionUID = -2851852959439807542L;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public TupleSerializer() {
        }

        public TupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
            super(keyBuilderFactory);
        }

        @Override
        public byte[] serializeKey(Object obj) {
            long txId;
            if (obj instanceof ITxState0) {
                txId = ((ITxState)obj).getStartTimestamp();
            } else if (obj instanceof Long) {
                txId = (Long)obj;
            } else {
                throw new IllegalArgumentException("class=" + obj.getClass());
            }
            long tmp = Math.abs(txId);
            return this.getKeyBuilder().reset().append(tmp).getKey();
        }

        @Override
        public Long deserializeKey(ITuple tuple) {
            byte[] key = tuple.getKeyBuffer().array();
            long id = KeyBuilder.decodeLong(key, 0);
            return id;
        }

        @Override
        public ITxState0 deserialize(ITuple tuple) {
            byte[] val = tuple.getValueBuffer().array();
            long txId = KeyBuilder.decodeLong(val, 0);
            long readsOnCommitTime = KeyBuilder.decodeLong(val, 8);
            return new MyTxState(txId, readsOnCommitTime);
        }

        @Override
        public byte[] serializeVal(ITxState0 val) {
            return this.getKeyBuilder().reset().append(val.getStartTimestamp()).append(val.getReadsOnCommitTime()).getKey();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeByte(0);
        }
    }

    private static class MyTxState
    implements ITxState0 {
        private final long txId;
        private final long readsOnCommitTime;

        private MyTxState(long txId, long readsOnCommitTime) {
            this.txId = txId;
            this.readsOnCommitTime = readsOnCommitTime;
        }

        @Override
        public final long getStartTimestamp() {
            return this.txId;
        }

        @Override
        public final long getReadsOnCommitTime() {
            return this.readsOnCommitTime;
        }
    }
}

