/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.keys.KV;
import com.bigdata.btree.proc.LongAggregator;
import com.bigdata.search.FullTextIndex;
import com.bigdata.search.ITermMetadata;
import com.bigdata.search.ReadOnlyTermDocRecord;
import com.bigdata.search.TermFrequencyData;
import com.bigdata.search.TextIndexWriteProc;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

public class TokenBuffer<V extends Comparable<V>> {
    private static final Logger log = Logger.getLogger(TokenBuffer.class);
    private FullTextIndex<V> textIndexer;
    private final int capacity;
    private final TermFrequencyData<V>[] buffer;
    private int count = 0;
    private int ndocs;
    private int nfields;
    private int nterms;
    private V lastDocId;
    private long lastFieldId;

    public TokenBuffer(int capacity, FullTextIndex<V> textIndexer) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (textIndexer == null) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.textIndexer = textIndexer;
        this.buffer = new TermFrequencyData[capacity];
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.count; ++i) {
            this.buffer[i] = null;
        }
        this.count = 0;
        this.ndocs = 0;
        this.nfields = 0;
        this.nterms = 0;
        this.lastDocId = null;
        this.lastFieldId = -1L;
    }

    public int size() {
        return this.count;
    }

    public TermFrequencyData<V> get(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }

    public void add(V docId, int fieldId, String token) {
        boolean newField;
        if (log.isDebugEnabled()) {
            log.debug((Object)("docId=" + docId + ", fieldId=" + fieldId + ", token=" + token));
        }
        if (this.count == 0) {
            ++this.ndocs;
            ++this.nfields;
            this.lastDocId = docId;
            this.lastFieldId = fieldId;
            newField = true;
        } else if (this.lastDocId != docId) {
            ++this.ndocs;
            ++this.nfields;
            newField = true;
            this.buffer[this.count - 1].normalize();
        } else if (this.lastFieldId != (long)fieldId) {
            ++this.nfields;
            newField = true;
            this.buffer[this.count - 1].normalize();
        } else {
            newField = false;
        }
        if (newField && this.count == this.capacity) {
            this.flush();
        }
        if (newField) {
            this.buffer[this.count++] = new TermFrequencyData<V>(docId, fieldId, token);
            ++this.nterms;
        } else if (this.buffer[this.count - 1].add(token)) {
            ++this.nterms;
        }
        this.lastDocId = docId;
        this.lastFieldId = fieldId;
    }

    public void flush() {
        if (this.nterms == 0) {
            this.reset();
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("count=" + this.count + ", ndocs=" + this.ndocs + ", nfields=" + this.nfields + ", nterms=" + this.nterms));
        }
        this.buffer[this.count - 1].normalize();
        Object[] a = new KV[this.nterms];
        ITupleSerializer tupleSer = this.textIndexer.getIndex().getIndexMetadata().getTupleSerializer();
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            TermFrequencyData<V> termFreq = this.buffer[i];
            Object docId = termFreq.docId;
            int fieldId = termFreq.fieldId;
            for (Map.Entry<String, ITermMetadata> e : termFreq.terms.entrySet()) {
                String termText = e.getKey();
                ITermMetadata termMetadata = e.getValue();
                ReadOnlyTermDocRecord rec = new ReadOnlyTermDocRecord(termText, docId, fieldId, termMetadata.getLocalTermWeight());
                byte[] key = tupleSer.serializeKey(rec);
                byte[] val = tupleSer.serializeVal(rec);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("{" + termText + "," + docId + "," + fieldId + "}: #occurences=" + termMetadata.termFreq() + ", termWeight=" + termMetadata.getLocalTermWeight()));
                }
                a[n++] = new KV(key, val);
            }
        }
        assert (n == this.nterms) : "ntokens=" + this.nterms + ", n=" + n;
        Arrays.sort(a);
        byte[][] keys = new byte[this.nterms][];
        byte[][] vals = new byte[this.nterms][];
        for (int i = 0; i < this.nterms; ++i) {
            keys[i] = ((KV)a[i]).key;
            vals[i] = ((KV)a[i]).val;
        }
        this.writeOnIndex(n, keys, vals);
        this.reset();
    }

    protected long writeOnIndex(int n, byte[][] keys, byte[][] vals) {
        LongAggregator resultHandler = new LongAggregator();
        this.textIndexer.getIndex().submit(0, n, keys, vals, this.textIndexer.isOverwrite() ? TextIndexWriteProc.IndexWriteProcConstructor.OVERWRITE : TextIndexWriteProc.IndexWriteProcConstructor.NO_OVERWRITE, resultHandler);
        return resultHandler.getResult();
    }

    protected long deleteFromIndex(int n, byte[][] keys, byte[][] vals) {
        throw new RuntimeException("implement me");
    }
}

