/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore.sector;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.rawstore.AbstractRawStore;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IAllocationManagerStore;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rawstore.TransientResourceMetadata;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.rwstore.sector.MemStrategy;
import com.bigdata.rwstore.sector.MemoryManager;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.UUID;

public class MemStore
extends AbstractRawStore
implements IAllocationManagerStore {
    private final MemStrategy m_strategy;
    private final UUID m_uuid;
    private volatile boolean open = true;

    public MemStore(DirectBufferPool pool) {
        this(pool, Integer.MAX_VALUE);
    }

    public MemStore(DirectBufferPool pool, int bufferCapacity) {
        if (pool == null) {
            throw new IllegalArgumentException();
        }
        if (bufferCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.m_strategy = new MemStrategy(new MemoryManager(pool, bufferCapacity));
        this.m_uuid = UUID.randomUUID();
    }

    public MemStore(IMemoryManager mmgr) {
        this(mmgr, UUID.randomUUID());
    }

    private MemStore(IMemoryManager mmgr, UUID storeId) {
        if (mmgr == null) {
            throw new IllegalArgumentException();
        }
        this.m_strategy = new MemStrategy(mmgr);
        this.m_uuid = storeId;
    }

    public MemStrategy getStrategy() {
        return this.m_strategy;
    }

    public IMemoryManager getMemoryManager() {
        return this.m_strategy.getStore();
    }

    public MemStore createAllocationContext() {
        return new MemStore(this.m_strategy.getStore().createAllocationContext(), this.m_uuid);
    }

    @Override
    public ByteBuffer read(long addr) {
        return this.m_strategy.read(addr);
    }

    @Override
    public long write(ByteBuffer data) {
        return this.m_strategy.write(data);
    }

    @Override
    public long write(ByteBuffer data, IAllocationContext context) {
        return this.m_strategy.write(data, context);
    }

    @Override
    public void delete(long addr) {
        this.m_strategy.delete(addr);
    }

    @Override
    public void delete(long addr, IAllocationContext context) {
        this.m_strategy.delete(addr, context);
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("UUID", new OneShotInstrument<String>(this.getUUID().toString()));
        root.attach(this.m_strategy.getStore().getCounters());
        return root;
    }

    private void assertOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Not open");
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.assertOpen();
        this.open = false;
        this.m_strategy.close();
    }

    @Override
    public void deleteResources() {
        if (this.open) {
            throw new IllegalStateException("Open");
        }
        this.m_strategy.deleteResources();
    }

    @Override
    public void destroy() {
        this.open = false;
        this.deleteResources();
    }

    @Override
    public void force(boolean metadata) {
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public IResourceMetadata getResourceMetadata() {
        return new TransientResourceMetadata(this.m_uuid);
    }

    @Override
    public UUID getUUID() {
        return this.m_uuid;
    }

    @Override
    public boolean isFullyBuffered() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public long size() {
        return this.m_strategy.size();
    }

    @Override
    public IAddressManager getAddressManager() {
        return this.m_strategy.getAddressManager();
    }

    @Override
    public int getByteCount(long addr) {
        return this.getAddressManager().getByteCount(addr);
    }

    @Override
    public long getOffset(long addr) {
        return this.getAddressManager().getOffset(addr);
    }

    @Override
    public long getPhysicalAddress(long addr) {
        return this.getAddressManager().getPhysicalAddress(addr);
    }

    @Override
    public long toAddr(int nbytes, long offset) {
        return this.getAddressManager().toAddr(nbytes, offset);
    }

    @Override
    public String toString(long addr) {
        return this.getAddressManager().toString(addr);
    }

    @Override
    public IPSOutputStream getOutputStream() {
        return this.m_strategy.getOutputStream();
    }

    @Override
    public IPSOutputStream getOutputStream(IAllocationContext context) {
        return this.m_strategy.getOutputStream(context);
    }

    @Override
    public InputStream getInputStream(long addr) {
        return this.m_strategy.getInputStream(addr);
    }
}

