/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import com.bigdata.rwstore.FixedAllocator;
import com.bigdata.rwstore.sector.SectorAllocator;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;

public class StorageStats {
    final int cVersion = 256;
    final int m_maxFixed;
    final ArrayList<Bucket> m_buckets;
    final ArrayList<BlobBucket> m_blobBuckets;
    long m_blobAllocation;
    long m_blobDeletion;

    public StorageStats(int[] buckets) {
        this.m_buckets = new ArrayList();
        int prevLimit = 0;
        for (int i = 0; i < buckets.length; ++i) {
            this.m_buckets.add(new Bucket(buckets[i] * 64, prevLimit));
            prevLimit = buckets[i] * 64;
        }
        this.m_maxFixed = this.m_buckets.get((int)(buckets.length - 1)).m_size;
        this.m_blobBuckets = new ArrayList();
        int curInc = this.m_maxFixed;
        int nxtBlob = this.m_maxFixed;
        int cMaxBucket = 0x4000000;
        while (nxtBlob < 0x4000000) {
            this.m_blobBuckets.add(new BlobBucket(nxtBlob += curInc));
            curInc *= 2;
        }
        this.m_blobBuckets.add(new BlobBucket(Integer.MAX_VALUE));
    }

    public StorageStats(DataInputStream instr) throws IOException {
        int version = instr.readInt();
        if (256 != version) {
            throw new IllegalStateException("StorageStats object is wrong version");
        }
        this.m_buckets = new ArrayList();
        int nbuckets = instr.readInt();
        for (int i = 0; i < nbuckets; ++i) {
            this.m_buckets.add(new Bucket(instr));
        }
        this.m_maxFixed = this.m_buckets.get((int)(this.m_buckets.size() - 1)).m_size;
        this.m_blobBuckets = new ArrayList();
        int nblobbuckets = instr.readInt();
        for (int i = 0; i < nblobbuckets; ++i) {
            this.m_blobBuckets.add(new BlobBucket(instr));
        }
        this.m_blobAllocation = instr.readLong();
        this.m_blobDeletion = instr.readLong();
    }

    public byte[] getData() throws IOException {
        ByteArrayOutputStream outb = new ByteArrayOutputStream();
        DataOutputStream outd = new DataOutputStream(outb);
        outd.writeInt(256);
        outd.writeInt(this.m_buckets.size());
        for (Bucket bucket : this.m_buckets) {
            bucket.write(outd);
        }
        outd.writeInt(this.m_blobBuckets.size());
        for (BlobBucket blobBucket : this.m_blobBuckets) {
            blobBucket.write(outd);
        }
        outd.writeLong(this.m_blobAllocation);
        outd.writeLong(this.m_blobDeletion);
        outd.flush();
        return outb.toByteArray();
    }

    public void allocateBlob(int sze) {
        this.m_blobAllocation += (long)sze;
        this.findBlobBucket(sze).allocate(sze);
    }

    public void deleteBlob(int sze) {
        this.m_blobDeletion -= (long)sze;
        this.findBlobBucket(sze).delete(sze);
    }

    public Bucket findBucket(int sze) {
        for (Bucket b : this.m_buckets) {
            if (sze != b.m_size) continue;
            return b;
        }
        throw new IllegalStateException("Buckets have not been correctly set");
    }

    private BlobBucket findBlobBucket(int sze) {
        for (BlobBucket b : this.m_blobBuckets) {
            if (sze >= b.m_size) continue;
            return b;
        }
        throw new IllegalStateException("BlobBuckets have not been correctly set");
    }

    public void register(FixedAllocator alloc, boolean init) {
        int block = alloc.getBlockSize();
        for (Bucket b : this.m_buckets) {
            if (b.m_size != block) continue;
            alloc.setBucketStats(b);
            if (init) {
                b.addAlocator();
            }
            return;
        }
        throw new IllegalArgumentException("FixedAllocator with unexpected block size");
    }

    public void register(FixedAllocator alloc) {
        this.register(alloc, false);
    }

    public void showStats(StringBuilder str) {
        str.append("\n-------------------------\n");
        str.append("RWStore Allocator Summary\n");
        str.append("-------------------------\n");
        str.append(String.format("%-16s %16s %16s %16s %16s %16s %16s %16s %16s %16s %16s %16s %16s %16s %16s %16s %16s %16s \n", "AllocatorSize", "AllocatorCount", "SlotsAllocated", "%SlotsAllocated", "SlotsRecycled", "SlotChurn", "SlotsInUse", "%SlotsInUse", "MeanAllocation", "SlotsReserved", "%SlotsUnused", "BytesReserved", "BytesAppData", "%SlotWaste", "%AppData", "%StoreFile", "%TotalWaste", "%FileWaste"));
        long totalAppData = 0L;
        long totalFileStore = 0L;
        long totalAllocations = 0L;
        long totalInuse = 0L;
        for (Bucket b : this.m_buckets) {
            totalAppData += b.usedStore();
            totalFileStore += b.reservedStore();
            totalAllocations += b.m_slotAllocations;
            totalInuse += b.usedSlots();
        }
        long totalWaste = totalFileStore - totalAppData;
        for (Bucket bucket : this.m_buckets) {
            str.append(String.format("%-16d %16d %16d %16.2f %16d %16.2f %16d %16.2f %16d %16d %16.2f %16d %16d %16.2f %16.2f %16.2f %16.2f  %16.2f \n", bucket.m_size, bucket.m_allocators, bucket.m_slotAllocations, Float.valueOf(bucket.percentAllocations(totalAllocations)), bucket.m_slotDeletes, Float.valueOf(bucket.slotChurn()), bucket.usedSlots(), Float.valueOf(bucket.percentSlotsInuse(totalInuse)), bucket.meanAllocation(), bucket.m_totalSlots, Float.valueOf(bucket.slotsUnused()), bucket.reservedStore(), bucket.usedStore(), Float.valueOf(bucket.slotWaste()), Float.valueOf(StorageStats.dataPercent(bucket.usedStore(), totalAppData)), Float.valueOf(StorageStats.dataPercent(bucket.reservedStore(), totalFileStore)), Float.valueOf(bucket.totalWaste(totalWaste)), Float.valueOf(bucket.totalWaste(totalFileStore))));
        }
        str.append("\n-------------------------\n");
        str.append("BLOBS\n");
        str.append("-------------------------\n");
        str.append(String.format("%-10s %12s %12s %12s %12s %12s\n", "Bucket(K)", "Allocations", "Allocated", "Deletes", "Current", "Mean"));
        for (BlobBucket blobBucket : this.m_blobBuckets) {
            str.append(String.format("%-10d %12d %12d %12d %12d %12d\n", blobBucket.m_size / 1024, blobBucket.m_allocations, blobBucket.m_allocationSize, blobBucket.m_deletes, blobBucket.m_allocations - blobBucket.m_deletes, blobBucket.meanAllocation()));
        }
    }

    private static float dataPercent(long usedData, long totalData) {
        if (totalData == 0L) {
            return 0.0f;
        }
        BigDecimal used = new BigDecimal(100L * usedData);
        BigDecimal total = new BigDecimal(totalData);
        return used.divide(total, 2, RoundingMode.HALF_UP).floatValue();
    }

    public void register(SectorAllocator allocator, boolean init) {
        throw new UnsupportedOperationException();
    }

    public void commit() {
        for (Bucket bucket : this.m_buckets) {
            bucket.commit();
        }
        for (BlobBucket blobBucket : this.m_blobBuckets) {
            blobBucket.commit();
        }
    }

    public void reset() {
        for (Bucket bucket : this.m_buckets) {
            bucket.reset();
        }
        for (BlobBucket blobBucket : this.m_blobBuckets) {
            blobBucket.reset();
        }
    }

    public Iterator<Bucket> getBuckets() {
        return this.m_buckets.iterator();
    }

    public class Bucket {
        final int m_start;
        final int m_size;
        int m_allocators;
        long m_totalSlots;
        long m_slotAllocations;
        long m_slotDeletes;
        long m_sizeAllocations;
        Bucket m_committed = null;

        public Bucket(int size, int startRange) {
            this.m_size = size;
            this.m_start = startRange;
        }

        public Bucket(DataInputStream instr) throws IOException {
            this.m_size = instr.readInt();
            this.m_start = instr.readInt();
            this.m_allocators = instr.readInt();
            this.m_slotAllocations = instr.readLong();
            this.m_slotDeletes = instr.readLong();
            this.m_totalSlots = instr.readLong();
            this.m_sizeAllocations = instr.readLong();
            instr.readLong();
            this.commit();
        }

        public void write(DataOutputStream outstr) throws IOException {
            outstr.writeInt(this.m_size);
            outstr.writeInt(this.m_start);
            outstr.writeInt(this.m_allocators);
            outstr.writeLong(this.m_slotAllocations);
            outstr.writeLong(this.m_slotDeletes);
            outstr.writeLong(this.m_totalSlots);
            outstr.writeLong(this.m_sizeAllocations);
            outstr.writeLong(0L);
        }

        public void commit() {
            if (this.m_committed == null) {
                this.m_committed = new Bucket(this.m_size, this.m_start);
            }
            this.m_committed.m_allocators = this.m_allocators;
            this.m_committed.m_slotAllocations = this.m_slotAllocations;
            this.m_committed.m_slotDeletes = this.m_slotDeletes;
            this.m_committed.m_totalSlots = this.m_totalSlots;
            this.m_committed.m_sizeAllocations = this.m_sizeAllocations;
        }

        public void reset() {
            if (this.m_committed != null) {
                this.m_allocators = this.m_committed.m_allocators;
                this.m_slotAllocations = this.m_committed.m_slotAllocations;
                this.m_slotDeletes = this.m_committed.m_slotDeletes;
                this.m_totalSlots = this.m_committed.m_totalSlots;
                this.m_sizeAllocations = this.m_committed.m_sizeAllocations;
            } else {
                this.m_allocators = 0;
                this.m_slotAllocations = 0L;
                this.m_slotDeletes = 0L;
                this.m_totalSlots = 0L;
                this.m_sizeAllocations = 0L;
            }
        }

        public void delete(int sze) {
            if (sze < 0) {
                throw new IllegalArgumentException("delete requires positive size, got: " + sze);
            }
            if (sze > this.m_size) {
                throw new IllegalArgumentException("Deletion of address with size greater than slot - " + sze + " > " + this.m_size);
            }
            ++this.m_slotDeletes;
        }

        public void allocate(int sze) {
            if (sze <= 0) {
                throw new IllegalArgumentException("allocate requires positive size, got: " + sze);
            }
            this.m_sizeAllocations += (long)sze;
            ++this.m_slotAllocations;
        }

        public void addSlots(int slots) {
            this.m_totalSlots += (long)slots;
        }

        public long usedSlots() {
            return this.m_slotAllocations - this.m_slotDeletes;
        }

        public long emptySlots() {
            return this.m_totalSlots - this.usedSlots();
        }

        public long usedStore() {
            return this.usedSlots() * (long)this.m_size;
        }

        public float slotWaste() {
            if (this.usedStore() == 0L) {
                return 0.0f;
            }
            BigDecimal size = new BigDecimal(this.reservedStore());
            BigDecimal store = new BigDecimal(100L * (this.reservedStore() - this.usedStore()));
            if (size.signum() == 0) {
                return 0.0f;
            }
            return store.divide(size, 2, RoundingMode.HALF_UP).floatValue();
        }

        public float totalWaste(long total) {
            if (total == 0L) {
                return 0.0f;
            }
            long slotWaste = this.reservedStore() - this.usedStore();
            BigDecimal localWaste = new BigDecimal(100L * slotWaste);
            BigDecimal totalWaste = new BigDecimal(total);
            if (totalWaste.signum() == 0) {
                return 0.0f;
            }
            return localWaste.divide(totalWaste, 2, RoundingMode.HALF_UP).floatValue();
        }

        public long reservedStore() {
            return (long)this.m_size * this.m_totalSlots;
        }

        public long reservedSlots() {
            return this.m_totalSlots;
        }

        public void addAlocator() {
            ++this.m_allocators;
        }

        public float slotChurn() {
            BigDecimal slotsAllocated = new BigDecimal(this.m_slotAllocations);
            BigDecimal slotsReserved = new BigDecimal(this.m_totalSlots);
            if (slotsReserved.signum() == 0) {
                return 0.0f;
            }
            return slotsAllocated.divide(slotsReserved, 2, RoundingMode.HALF_UP).floatValue();
        }

        public float slotsUnused() {
            if (this.m_totalSlots == 0L) {
                return 0.0f;
            }
            BigDecimal used = new BigDecimal(100L * (this.m_totalSlots - this.usedSlots()));
            BigDecimal total = new BigDecimal(this.m_totalSlots);
            if (total.signum() == 0) {
                return 0.0f;
            }
            return used.divide(total, 2, RoundingMode.HALF_UP).floatValue();
        }

        public float percentAllocations(long totalAllocations) {
            if (totalAllocations == 0L) {
                return 0.0f;
            }
            BigDecimal used = new BigDecimal(100L * this.m_slotAllocations);
            BigDecimal total = new BigDecimal(totalAllocations);
            if (total.signum() == 0) {
                return 0.0f;
            }
            return used.divide(total, 2, RoundingMode.HALF_UP).floatValue();
        }

        public float percentSlotsInuse(long totalInuse) {
            if (totalInuse == 0L) {
                return 0.0f;
            }
            BigDecimal used = new BigDecimal(100L * this.usedSlots());
            BigDecimal total = new BigDecimal(totalInuse);
            if (total.signum() == 0) {
                return 0.0f;
            }
            return used.divide(total, 2, RoundingMode.HALF_UP).floatValue();
        }

        public int meanAllocation() {
            if (this.m_slotAllocations == 0L) {
                return 0;
            }
            return (int)(this.m_sizeAllocations / this.m_slotAllocations);
        }
    }

    public class BlobBucket {
        final int m_size;
        long m_allocationSize;
        long m_allocations;
        long m_deletes;
        BlobBucket m_committed = null;

        public BlobBucket(int size) {
            this.m_size = size;
        }

        public BlobBucket(DataInputStream instr) throws IOException {
            this.m_size = instr.readInt();
            this.m_allocationSize = instr.readLong();
            this.m_allocations = instr.readLong();
            instr.readLong();
            this.m_deletes = instr.readLong();
            this.commit();
        }

        public void write(DataOutputStream outstr) throws IOException {
            outstr.writeInt(this.m_size);
            outstr.writeLong(this.m_allocationSize);
            outstr.writeLong(this.m_allocations);
            outstr.writeLong(0L);
            outstr.writeLong(this.m_deletes);
        }

        public void commit() {
            if (this.m_committed == null) {
                this.m_committed = new BlobBucket(this.m_size);
            }
            this.m_committed.m_allocationSize = this.m_allocationSize;
            this.m_committed.m_allocations = this.m_allocations;
            this.m_committed.m_deletes = this.m_deletes;
        }

        public void reset() {
            if (this.m_committed != null) {
                this.m_allocationSize = this.m_committed.m_allocationSize;
                this.m_allocations = this.m_committed.m_allocations;
                this.m_deletes = this.m_committed.m_deletes;
            } else {
                this.m_allocationSize = 0L;
                this.m_allocations = 0L;
                this.m_deletes = 0L;
            }
        }

        public void delete(int sze) {
            ++this.m_deletes;
        }

        public void allocate(int sze) {
            this.m_allocationSize += (long)sze;
            ++this.m_allocations;
        }

        public long active() {
            return this.m_allocations - this.m_deletes;
        }

        public int meanAllocation() {
            if (this.m_allocations == 0L) {
                return 0;
            }
            return (int)(this.m_allocationSize / this.m_allocations);
        }
    }
}

