/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import java.io.IOException;
import java.io.OutputStream;

public class FixedOutputStream
extends OutputStream {
    private final byte[] m_buf;
    private int m_count = 0;

    public FixedOutputStream(byte[] buf) {
        this.m_buf = buf;
    }

    public void writeInt(int b) {
        this.m_buf[this.m_count++] = (byte)(b >>> 24 & 0xFF);
        this.m_buf[this.m_count++] = (byte)(b >>> 16 & 0xFF);
        this.m_buf[this.m_count++] = (byte)(b >>> 8 & 0xFF);
        this.m_buf[this.m_count++] = (byte)(b >>> 0 & 0xFF);
    }

    @Override
    public void write(int b) throws IOException {
        this.m_buf[this.m_count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        System.arraycopy(b, off, this.m_buf, this.m_count, len);
        this.m_count += len;
    }

    public void writeLong(long txReleaseTime) {
        this.writeInt((int)(txReleaseTime >> 32));
        this.writeInt((int)txReleaseTime & 0xFFFFFFFF);
    }
}

