/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.util;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.rio.IRDFParserOptions;
import com.bigdata.rdf.rio.RDFParserOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class VocabBuilder {
    private static final Logger log = Logger.getLogger(VocabBuilder.class);
    private final IRDFParserOptions parserOptions;
    private final Map<URI, P> preds = new LinkedHashMap<URI, P>();
    private static final FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            boolean isRDF;
            if (new File(dir, name).isDirectory()) {
                return !dir.isHidden();
            }
            boolean bl = isRDF = RDFFormat.forFileName((String)name) != null || name.endsWith(".zip") && RDFFormat.forFileName((String)name.substring(0, name.length() - 4)) != null || name.endsWith(".gz") && RDFFormat.forFileName((String)name.substring(0, name.length() - 3)) != null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("dir=" + dir + ", name=" + name + " : isRDF=" + isRDF));
            }
            return isRDF;
        }
    };

    private VocabBuilder() {
        this.parserOptions = new RDFParserOptions();
        this.parserOptions.setStopAtFirstError(false);
        this.parserOptions.setVerifyData(false);
    }

    /*
     * Loose catch block
     */
    protected void loadFiles(int depth, File file, String baseURI, RDFFormat rdfFormat, FilenameFilter filter) throws IOException {
        RDFParserFactory rdfParserFactory;
        if (file.isDirectory()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading directory: " + file));
            }
            File[] files = filter != null ? file.listFiles(filter) : file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                this.loadFiles(depth + 1, f, baseURI, rdfFormat, filter);
            }
            return;
        }
        String n = file.getName();
        RDFFormat fmt = RDFFormat.forFileName((String)n);
        if (fmt == null && n.endsWith(".zip")) {
            fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 4));
        }
        if (fmt == null && n.endsWith(".gz")) {
            fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 3));
        }
        if (fmt == null) {
            fmt = rdfFormat;
        }
        if ((rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)fmt)) == null) {
            throw new RuntimeException("Parser factory not found: source=" + file + ", fmt=" + fmt);
        }
        RDFParser rdfParser = rdfParserFactory.getParser();
        rdfParser.setVerifyData(this.parserOptions.getVerifyData());
        rdfParser.setStopAtFirstError(this.parserOptions.getStopAtFirstError());
        rdfParser.setDatatypeHandling(this.parserOptions.getDatatypeHandling());
        rdfParser.setPreserveBNodeIDs(this.parserOptions.getPreserveBNodeIDs());
        rdfParser.setRDFHandler((RDFHandler)new AddStatementHandler());
        try (InputStream is = null;){
            is = new FileInputStream(file);
            if (n.endsWith(".gz")) {
                is = new GZIPInputStream(is);
            } else if (n.endsWith(".zip")) {
                is = new ZipInputStream(is);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String s = baseURI != null ? baseURI : file.toURI().toString();
                rdfParser.parse((Reader)reader, s);
                return;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static void main(String[] args) {
        boolean generate = true;
        int minFreq = 10;
        VocabBuilder v = new VocabBuilder();
        String baseURI = null;
        RDFFormat rdfFormat = RDFFormat.RDFXML;
        for (String file : args) {
            if (log.isInfoEnabled()) {
                log.info((Object)("file: " + file));
            }
            try {
                v.loadFiles(0, new File(file), baseURI, rdfFormat, filter);
            }
            catch (IOException ex) {
                log.error((Object)("Could not read: file=" + file), (Throwable)ex);
            }
        }
        int size = v.preds.size();
        Object[] a = v.preds.values().toArray(new P[size]);
        if (log.isInfoEnabled()) {
            log.info((Object)("Sorting " + a.length + " vocabulary items from " + args.length + " files"));
        }
        Arrays.sort(a);
        String className = "MyVocabularyDecl";
        System.out.println("import java.util.Arrays;");
        System.out.println("import java.util.Collections;");
        System.out.println("import java.util.Iterator;");
        System.out.println("import org.openrdf.model.URI;");
        System.out.println("import org.openrdf.model.impl.URIImpl;");
        System.out.println("import com.bigdata.rdf.vocab.VocabularyDecl;");
        System.out.println("public class MyVocabularyDecl implements VocabularyDecl {");
        System.out.println("static private final URI[] uris = new URI[] {");
        for (int i = 0; i < size; ++i) {
            Object p = a[i];
            if (((P)p).cnt < 10) break;
            System.out.println("new URIImpl(\"" + ((P)p).uri + "\"), // rank=" + i + ", count=" + ((P)p).cnt);
        }
        System.out.println("};");
        System.out.println("public MyVocabularyDecl() {}");
        System.out.println("public Iterator<URI> values() {\nreturn Collections.unmodifiableList(Arrays.asList(uris)).iterator();\n}");
        System.out.println("}");
    }

    static {
        ServiceProviderHook.forceLoad();
    }

    private static class P
    implements Comparable<P> {
        final URI uri;
        int cnt;

        public P(URI uri) {
            this.uri = uri;
        }

        @Override
        public int compareTo(P arg0) {
            return arg0.cnt - this.cnt;
        }
    }

    private class AddStatementHandler
    extends RDFHandlerBase {
        public void handleStatement(Statement stmt) throws RDFHandlerException {
            URI p = stmt.getPredicate();
            P i = (P)VocabBuilder.this.preds.get(p);
            if (i == null) {
                i = new P(p);
                VocabBuilder.this.preds.put(p, i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New " + p + " : total=" + VocabBuilder.this.preds.size()));
                }
            }
            ++i.cnt;
        }
    }
}

