/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.RDFValueFactory;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SPOTupleSerializer
extends DefaultTupleSerializer<SPO, SPO> {
    private static final long serialVersionUID = 2893830958762265104L;
    private SPOKeyOrder keyOrder;
    private boolean sids;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION1 = 1;
    private static final transient byte VERSION = 1;

    public SPOKeyOrder getKeyOrder() {
        return this.keyOrder;
    }

    public SPOTupleSerializer() {
    }

    public SPOTupleSerializer(SPOKeyOrder keyOrder, boolean sids) {
        this(keyOrder, sids, SPOTupleSerializer.getDefaultLeafKeysCoder(), SPOTupleSerializer.getDefaultValuesCoder());
    }

    public SPOTupleSerializer(SPOKeyOrder keyOrder, boolean sids, IRabaCoder leafKeySer, IRabaCoder leafValSer) {
        super(new ASCIIKeyBuilderFactory(), leafKeySer, leafValSer);
        this.keyOrder = keyOrder;
        this.sids = sids;
    }

    @Override
    public byte[] serializeKey(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof SPO) {
            return this.serializeKey((SPO)obj);
        }
        throw new UnsupportedOperationException();
    }

    public byte[] serializeKey(ISPO spo) {
        return this.keyOrder.encodeKey(this.getKeyBuilder(), spo);
    }

    @Override
    public byte[] serializeVal(ISPO spo) {
        if (spo == null) {
            throw new IllegalArgumentException();
        }
        return this.serializeVal(spo.isOverride(), spo.getUserFlag(), spo.getStatementType());
    }

    @Override
    public byte[] serializeVal(SPO spo) {
        if (spo == null) {
            throw new IllegalArgumentException();
        }
        return this.serializeVal(spo.isOverride(), spo.getUserFlag(), spo.getStatementType());
    }

    public byte[] serializeVal(boolean override, boolean userFlag, StatementEnum type) {
        byte b = (byte)(type.code() | (override ? 8 : 0) | (userFlag ? 4 : 0));
        return RDFValueFactory.getValue(b);
    }

    @Override
    public SPO deserialize(ITuple tuple) {
        if (tuple == null) {
            throw new IllegalArgumentException();
        }
        byte[] key = tuple.getKeyBuffer().array();
        SPO spo = this.keyOrder.decodeKey(key);
        if ((tuple.flags() & 2) == 0) {
            return spo;
        }
        ByteArrayBuffer vbuf = tuple.getValueBuffer();
        this.decodeValue(spo, vbuf.array());
        return spo;
    }

    @Override
    public SPO deserializeKey(ITuple tuple) {
        return this.deserialize(tuple);
    }

    public ISPO decodeValue(ISPO spo, byte[] val) {
        byte code = val[0];
        StatementEnum type = StatementEnum.decode(code);
        spo.setStatementType(type);
        spo.setOverride(StatementEnum.isOverride(code));
        spo.setUserFlag(StatementEnum.isUserFlag(code));
        return spo;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                this.keyOrder = SPOKeyOrder.valueOf(in.readByte());
                this.sids = false;
                break;
            }
            case 1: {
                this.keyOrder = SPOKeyOrder.valueOf(in.readByte());
                this.sids = in.readByte() > 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
        out.writeByte(this.keyOrder.index());
        out.writeByte(this.sids ? 1 : 0);
    }
}

