/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sail.webapp.client.AST2SPARQLUtil;
import com.bigdata.rdf.sparql.ast.service.IRemoteSparqlQueryBuilder;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.EmptyBindingSet;

public class RemoteSparql10QueryBuilder
implements IRemoteSparqlQueryBuilder {
    private static final Logger log = Logger.getLogger(RemoteSparql10QueryBuilder.class);
    private final String exprImage;
    private final Map<String, String> prefixDecls;
    private final AST2SPARQLUtil util;
    private final Set<IVariable<?>> projectedVars;

    public RemoteSparql10QueryBuilder(ServiceNode serviceNode) {
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        this.exprImage = serviceNode.getExprImage();
        this.prefixDecls = serviceNode.getPrefixDecls();
        this.projectedVars = serviceNode.getProjectedVars();
        if (this.exprImage == null) {
            throw new IllegalArgumentException();
        }
        if (this.projectedVars == null) {
            throw new IllegalArgumentException();
        }
        this.util = new AST2SPARQLUtil(this.prefixDecls);
    }

    @Override
    public String getSparqlQuery(BindingSet[] bindingSets) {
        if (bindingSets.length == 0) {
            bindingSets = new BindingSet[]{new EmptyBindingSet()};
        } else if (bindingSets.length != 1 || bindingSets[0].size() == 0) {
            // empty if block
        }
        StringBuilder sb = new StringBuilder();
        if (this.prefixDecls != null) {
            for (Map.Entry<String, String> entry : this.prefixDecls.entrySet()) {
                sb.append("\n");
                sb.append("prefix ");
                sb.append(entry.getKey());
                sb.append(":");
                sb.append(" <");
                sb.append(entry.getValue());
                sb.append(">");
                sb.append("\n");
            }
        }
        sb.append("SELECT ");
        if (this.projectedVars.isEmpty()) {
            sb.append("*");
        } else {
            for (IVariable iVariable : this.projectedVars) {
                sb.append(" ?");
                sb.append(iVariable.getName());
            }
        }
        sb.append("\n");
        int beginIndex = this.exprImage.indexOf("{") + 1;
        if (beginIndex < 0) {
            throw new RuntimeException();
        }
        int n = this.exprImage.lastIndexOf("}");
        if (n < beginIndex) {
            throw new RuntimeException();
        }
        String tmp = this.exprImage.substring(beginIndex, n);
        sb.append("WHERE {\n");
        for (int k = 0; k < bindingSets.length; ++k) {
            Map<BNode, Set<String>> bnodes;
            BindingSet bset = bindingSets[k];
            if (bindingSets.length > 1) {
                if (k == 0) {
                    sb.append("{\n");
                } else {
                    sb.append("\n} UNION {\n");
                }
            }
            if ((bnodes = RemoteSparql10QueryBuilder.getCorrelatedVarsMap(bset)) != null) {
                for (Set<String> sameTermVars : bnodes.values()) {
                    int nSameTerm = sameTermVars.size();
                    if (nSameTerm < 2) continue;
                    String[] names = sameTermVars.toArray(new String[nSameTerm]);
                    sb.append("FILTER (");
                    for (int i = 1; i < names.length; ++i) {
                        if (i > 1) {
                            sb.append(" &&");
                        }
                        sb.append(" sameTerm( ?" + names[0] + ", ?" + names[i] + ")");
                    }
                    sb.append(" ).\n");
                }
            }
            for (Binding b : bset) {
                String name = b.getName();
                Value v = b.getValue();
                if (v instanceof BNode) continue;
                sb.append("FILTER (");
                sb.append(" sameTerm( ?" + name + ", " + this.util.toExternal(v) + ")");
                sb.append(" ).\n");
            }
            sb.append(tmp);
        }
        if (bindingSets.length > 1) {
            sb.append("\n}\n");
        }
        sb.append("\n}\n");
        String q = sb.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + q));
        }
        return q;
    }

    private static Map<BNode, Set<String>> getCorrelatedVarsMap(BindingSet bindingSet) {
        LinkedHashMap<BNode, LinkedHashSet<String>> bnodes = null;
        for (Binding b : bindingSet) {
            BNode bnd;
            LinkedHashSet<String> cvars;
            Value v = b.getValue();
            if (!(v instanceof BNode)) continue;
            if (bnodes == null) {
                bnodes = new LinkedHashMap<BNode, LinkedHashSet<String>>();
            }
            if ((cvars = (LinkedHashSet<String>)bnodes.get(bnd = (BNode)v)) == null) {
                cvars = new LinkedHashSet<String>();
                bnodes.put(bnd, cvars);
            }
            if (!cvars.add(b.getName())) {
                throw new AssertionError();
            }
        }
        return bnodes;
    }
}

