/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import cutthecrap.utils.striterators.Striterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ASTSparql11SubqueryOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        if (namedSubqueries != null) {
            List<NamedSubqueryRoot> list = BOpUtility.toList(namedSubqueries, NamedSubqueryRoot.class);
            for (NamedSubqueryRoot namedSubquery : list) {
                this.liftSubqueries(context, sa, namedSubquery.getWhereClause());
            }
        }
        this.liftSubqueries(context, sa, queryRoot.getWhereClause());
        return new QueryNodeWithBindingSet(queryRoot, bindingSets);
    }

    private void liftSubqueries(AST2BOpContext context, StaticAnalysis sa, GraphPatternGroup<IGroupMemberNode> group) {
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            SubqueryRoot subqueryRoot;
            BOp child = group.get(i);
            if (child instanceof GraphPatternGroup) {
                this.liftSubqueries(context, sa, (GraphPatternGroup)child);
            } else if (child instanceof SubqueryRoot) {
                subqueryRoot = (SubqueryRoot)child;
                this.liftSubqueries(context, sa, subqueryRoot.getWhereClause());
            } else if (child instanceof ServiceNode) continue;
            if (!(child instanceof SubqueryRoot) || (subqueryRoot = (SubqueryRoot)child).getQueryType() == QueryType.ASK) continue;
            if (subqueryRoot.hasSlice()) {
                this.liftSparql11Subquery(context, sa, subqueryRoot);
                continue;
            }
            if (subqueryRoot.hasSlice() && subqueryRoot.getOrderBy() != null) {
                this.liftSparql11Subquery(context, sa, subqueryRoot);
                continue;
            }
            if (StaticAnalysis.isAggregate(subqueryRoot)) {
                this.liftSparql11Subquery(context, sa, subqueryRoot);
                continue;
            }
            if (!subqueryRoot.isRunOnce()) continue;
            this.liftSparql11Subquery(context, sa, subqueryRoot);
        }
    }

    private void rewriteSparql11Subqueries(AST2BOpContext context, StaticAnalysis sa, QueryRoot queryRoot) {
        Striterator itr2 = new Striterator(BOpUtility.postOrderIterator(queryRoot.getWhereClause()));
        itr2.addTypeFilter(SubqueryRoot.class);
        LinkedList<SubqueryRoot> subqueries = new LinkedList<SubqueryRoot>();
        while (itr2.hasNext()) {
            subqueries.add((SubqueryRoot)itr2.next());
        }
        for (SubqueryRoot subquery : subqueries) {
            this.liftSparql11Subquery(context, sa, subquery);
        }
    }

    private void liftSparql11Subquery(AST2BOpContext context, StaticAnalysis sa, SubqueryRoot subqueryRoot) {
        IGroupNode<IGroupMemberNode> pp;
        IGroupNode<IGroupMemberNode> parent = subqueryRoot.getParent();
        String newName = "-subSelect-" + context.nextId();
        NamedSubqueryInclude include = new NamedSubqueryInclude(newName);
        include.setQueryHints((Properties)parent.getProperty("queryHints"));
        include.setAttachedJoinFilters(subqueryRoot.getAttachedJoinFilters());
        if (parent instanceof JoinGroupNode && !((JoinGroupNode)parent).isOptional() && !((JoinGroupNode)parent).isMinus() && parent.arity() == 1 && parent.getParent() != null && !(parent.getParent() instanceof UnionNode) ? ((ASTBase)((Object)(pp = parent.getParent()))).replaceWith(parent, include) == 0 : ((ASTBase)((Object)parent)).replaceWith(subqueryRoot, include) == 0) {
            throw new AssertionError();
        }
        NamedSubqueryRoot nsr = new NamedSubqueryRoot(subqueryRoot.getQueryType(), newName);
        nsr.setQueryHints(subqueryRoot.getQueryHints());
        nsr.setConstruct(subqueryRoot.getConstruct());
        nsr.setGroupBy(subqueryRoot.getGroupBy());
        nsr.setHaving(subqueryRoot.getHaving());
        nsr.setOrderBy(subqueryRoot.getOrderBy());
        nsr.setProjection(subqueryRoot.getProjection());
        nsr.setSlice(subqueryRoot.getSlice());
        nsr.setWhereClause(subqueryRoot.getWhereClause());
        nsr.setBindingsClause(subqueryRoot.getBindingsClause());
        sa.getQueryRoot().getNamedSubqueriesNotNull().add(nsr);
    }
}

