/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.GroupNodeVarBindingInfo;
import com.bigdata.rdf.sparql.ast.GroupNodeVarBindingInfoMap;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ASTJoinGroupPartition {
    final GroupNodeVarBindingInfoMap bindingInfoMap;
    final LinkedList<IGroupMemberNode> nonOptionalNonMinusNodes;
    final Set<IVariable<?>> externallyBound;
    IGroupMemberNode optionalOrMinus;
    Set<IVariable<?>> definitelyProduced;

    ASTJoinGroupPartition(LinkedList<IGroupMemberNode> nonOptionalNonMinusNodes, IGroupMemberNode optionalOrMinus, GroupNodeVarBindingInfoMap bindingInfoMap, Set<IVariable<?>> externallyBound) {
        this.nonOptionalNonMinusNodes = nonOptionalNonMinusNodes;
        this.optionalOrMinus = optionalOrMinus;
        this.bindingInfoMap = bindingInfoMap;
        this.externallyBound = externallyBound;
        this.recomputeDefinitelyProduced();
    }

    public List<IGroupMemberNode> extractNodeList(boolean includeOptionalOrMinusNode) {
        ArrayList<IGroupMemberNode> nodeList = new ArrayList<IGroupMemberNode>();
        nodeList.addAll(this.nonOptionalNonMinusNodes);
        if (includeOptionalOrMinusNode && this.optionalOrMinus != null) {
            nodeList.add(this.optionalOrMinus);
        }
        return nodeList;
    }

    public void addNonOptionalNonMinusNodeToPartition(IGroupMemberNode node) {
        this.nonOptionalNonMinusNodes.add(node);
        this.definitelyProduced.addAll(this.bindingInfoMap.get(node).getDefinitelyProduced());
    }

    public Set<IVariable<?>> getDefinitelyProduced() {
        return this.definitelyProduced;
    }

    public void replaceNonOptionalNonMinusNodesWith(List<IGroupMemberNode> ordered, boolean recomputeDefinitelyProduced) {
        this.nonOptionalNonMinusNodes.clear();
        this.nonOptionalNonMinusNodes.addAll(ordered);
        if (recomputeDefinitelyProduced) {
            this.recomputeDefinitelyProduced();
        }
    }

    public void removeNodesFromPartition(List<IGroupMemberNode> nodesToRemove) {
        for (IGroupMemberNode nodeToRemove : nodesToRemove) {
            if (nodeToRemove == null || this.nonOptionalNonMinusNodes.remove(nodeToRemove) || !nodeToRemove.equals(this.optionalOrMinus)) continue;
            this.optionalOrMinus = null;
        }
        this.recomputeDefinitelyProduced();
    }

    void placeAtFirstContributingPosition(IGroupMemberNode node, Set<IVariable<?>> additionalKnownBound, boolean requiresAllBound) {
        Integer firstPossiblePosition = this.getFirstPossiblePosition(node, additionalKnownBound, requiresAllBound);
        if (firstPossiblePosition == null) {
            this.placeAtPosition(node, firstPossiblePosition);
            return;
        }
        GroupNodeVarBindingInfo bindingInfo = this.bindingInfoMap.get(node);
        Set<IVariable<?>> maybeProducedByNode = bindingInfo.getMaybeProduced();
        HashSet intersectionWithExternallyIncomings = new HashSet();
        intersectionWithExternallyIncomings.addAll(this.externallyBound);
        intersectionWithExternallyIncomings.retainAll(maybeProducedByNode);
        if (!intersectionWithExternallyIncomings.isEmpty()) {
            this.placeAtPosition(node, firstPossiblePosition);
            return;
        }
        for (int i = 0; i < this.nonOptionalNonMinusNodes.size(); ++i) {
            Set<IVariable<?>> desiredBound = this.bindingInfoMap.get(this.nonOptionalNonMinusNodes.get(i)).getDesiredBound();
            HashSet intersection = new HashSet();
            intersection.addAll(desiredBound);
            intersection.retainAll(maybeProducedByNode);
            if (intersection.isEmpty()) continue;
            this.placeAtPosition(node, Math.max(i, firstPossiblePosition));
            return;
        }
        this.nonOptionalNonMinusNodes.addLast(node);
    }

    void placeAtFirstPossiblePosition(IGroupMemberNode node, Set<IVariable<?>> additionalKnownBound, boolean requiresAllBound) {
        this.placeAtPosition(node, this.getFirstPossiblePosition(node, additionalKnownBound, requiresAllBound));
        this.definitelyProduced.addAll(this.bindingInfoMap.get(node).getDefinitelyProduced());
    }

    void placeAtPosition(IGroupMemberNode node, Integer positionToPlace) {
        if (positionToPlace == null) {
            this.nonOptionalNonMinusNodes.addLast(node);
        } else {
            this.nonOptionalNonMinusNodes.add(positionToPlace, node);
        }
    }

    Integer getFirstPossiblePosition(IGroupMemberNode node, Set<IVariable<?>> additionalKnownBound, boolean requiresAllBound) {
        GroupNodeVarBindingInfo bindingInfo = this.bindingInfoMap.get(node);
        HashSet knownBound = new HashSet(this.externallyBound);
        knownBound.addAll(additionalKnownBound);
        HashMap remainingMaybeBound = new HashMap();
        if (!requiresAllBound) {
            for (IGroupMemberNode nonmNode : this.nonOptionalNonMinusNodes) {
                this.addMaybeProducedToMultiset(remainingMaybeBound, nonmNode);
            }
            if (this.optionalOrMinus != null) {
                this.addMaybeProducedToMultiset(remainingMaybeBound, this.optionalOrMinus);
            }
        }
        for (int i = 0; i < this.nonOptionalNonMinusNodes.size(); ++i) {
            if (this.canBePlacedAtPosition(requiresAllBound, bindingInfo, knownBound, remainingMaybeBound, i)) {
                return i;
            }
            IGroupMemberNode cur = this.nonOptionalNonMinusNodes.get(i);
            Set<IVariable<?>> definitelyProducedByCur = this.bindingInfoMap.get(cur).getDefinitelyProduced();
            knownBound.addAll(definitelyProducedByCur);
            if (requiresAllBound) continue;
            Set<IVariable<?>> maybeProducedByCur = this.bindingInfoMap.get(cur).getMaybeProduced();
            for (IVariable<?> var : maybeProducedByCur) {
                if (!remainingMaybeBound.containsKey(var)) continue;
                remainingMaybeBound.put(var, (Integer)remainingMaybeBound.get(var) - 1);
                if ((Integer)remainingMaybeBound.get(var) > 0) continue;
                remainingMaybeBound.remove(var);
            }
        }
        Integer lastPosition = this.nonOptionalNonMinusNodes.size();
        if (this.canBePlacedAtPosition(requiresAllBound, bindingInfo, knownBound, remainingMaybeBound, lastPosition)) {
            return lastPosition;
        }
        return null;
    }

    private boolean canBePlacedAtPosition(boolean requiresAllBound, GroupNodeVarBindingInfo bindingInfo, HashSet<IVariable<?>> knownBound, Map<IVariable<?>, Integer> remainingMaybeBound, int i) {
        Set<IVariable<?>> leftToBeBound = bindingInfo.leftToBeBound(knownBound);
        if (leftToBeBound.isEmpty()) {
            return true;
        }
        if (!requiresAllBound) {
            boolean moreCanBeBound = false;
            Set<IVariable<?>> canBeBound = remainingMaybeBound.keySet();
            for (IVariable<?> leftToBeBoundVar : leftToBeBound) {
                if (moreCanBeBound |= canBeBound.contains(leftToBeBoundVar)) break;
            }
            if (!moreCanBeBound) {
                return true;
            }
        }
        return false;
    }

    private void addMaybeProducedToMultiset(Map<IVariable<?>, Integer> multiset, IGroupMemberNode node) {
        GroupNodeVarBindingInfo bi = this.bindingInfoMap.get(node);
        for (IVariable<?> var : bi.getMaybeProduced()) {
            if (!multiset.containsKey(var)) {
                multiset.put(var, 1);
                continue;
            }
            multiset.put(var, multiset.get(var) + 1);
        }
    }

    private void recomputeDefinitelyProduced() {
        this.definitelyProduced = new HashSet();
        this.definitelyProduced.addAll(this.externallyBound);
        for (IGroupMemberNode node : this.nonOptionalNonMinusNodes) {
            this.definitelyProduced.addAll(this.bindingInfoMap.get(node).getDefinitelyProduced());
        }
    }
}

