/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.ap.filter.DistinctFilter;
import com.bigdata.bop.rdf.filter.NativeDistinctFilter;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataQuadWrapper;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import cutthecrap.utils.striterators.ICloseable;
import cutthecrap.utils.striterators.IFilterTest;
import cutthecrap.utils.striterators.IPropertySet;
import info.aduna.iteration.CloseableIteration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.impl.EmptyBindingSet;

public class ASTConstructIterator
implements CloseableIteration<BigdataStatement, QueryEvaluationException> {
    private static final Logger log = Logger.getLogger(ASTConstructIterator.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private final boolean constructDistinctSPO;
    private final BigdataValueFactory f;
    private final List<StatementPatternNode> templates;
    final Map<String, BigdataBNode> bnodes;
    private final List<BigdataStatement> groundTriples;
    private final CloseableIteration<BindingSet, QueryEvaluationException> src;
    private final LinkedList<BigdataStatement> buffer = new LinkedList();
    private final IFilterTest filter;
    private int bnodeIdFactory = 0;
    private boolean open = true;
    private boolean haveFirstSolution = false;
    public static boolean flagToCheckNativeDistinctQuadsInvocationForJUnitTesting = false;

    private final Map<String, BigdataBNode> getBNodeMap() {
        if (this.bnodes == null) {
            return new LinkedHashMap<String, BigdataBNode>();
        }
        return this.bnodes;
    }

    public ASTConstructIterator(AST2BOpContext context, AbstractTripleStore tripleStore, ConstructNode construct, GraphPatternGroup<?> whereClause, Map<String, BigdataBNode> bnodesIn, CloseableIteration<BindingSet, QueryEvaluationException> src) {
        this.constructDistinctSPO = context.constructDistinctSPO;
        this.f = tripleStore.getValueFactory();
        this.bnodes = bnodesIn;
        this.templates = new LinkedList<StatementPatternNode>();
        this.groundTriples = new LinkedList<BigdataStatement>();
        Map<String, BigdataBNode> bnodes = null;
        for (StatementPatternNode pat : construct) {
            if (pat.isGround()) {
                if (bnodes == null) {
                    bnodes = this.getBNodeMap();
                }
                BigdataStatement stmt = this.makeStatement(pat, EmptyBindingSet.getInstance(), bnodes);
                if (DEBUG) {
                    log.debug((Object)("Ground statement:\npattern=" + pat + "\nstmt=" + stmt));
                }
                this.groundTriples.add(stmt);
                continue;
            }
            this.templates.add(pat);
        }
        this.src = src;
        this.filter = this.createDistinctFilter(tripleStore, construct, whereClause);
    }

    private IFilterTest createDistinctFilter(AbstractTripleStore tripleStore, ConstructNode construct, GraphPatternGroup<?> whereClause) {
        boolean isObviouslyDistinct;
        boolean distinctQuads = construct.isDistinctQuads() && tripleStore.isQuads() && this.hasMixedQuadData(this.templates);
        boolean nativeDistinct = construct.isNativeDistinct();
        if (!this.constructDistinctSPO) {
            return null;
        }
        if (nativeDistinct && construct.isDistinctQuads()) {
            flagToCheckNativeDistinctQuadsInvocationForJUnitTesting = true;
        }
        if (isObviouslyDistinct = ASTConstructIterator.isObviouslyDistinct(tripleStore.isQuads(), this.templates, whereClause)) {
            return null;
        }
        if (distinctQuads) {
            if (nativeDistinct) {
                return this.createNativeDistinctQuadsFilter(construct);
            }
            return this.createHashDistinctQuadsFilter(construct);
        }
        if (nativeDistinct) {
            return this.createNativeDistinctTripleFilter(construct);
        }
        return new DistinctFilter.DistinctFilterImpl((IPropertySet)construct);
    }

    private IFilterTest createNativeDistinctQuadsFilter(ConstructNode construct) {
        return this.createHashDistinctQuadsFilter(construct);
    }

    private IFilterTest createHashDistinctQuadsFilter(ConstructNode construct) {
        return new DistinctFilter.DistinctFilterImpl((IPropertySet)construct){

            @Override
            public boolean isValid(Object o) {
                return super.isValid(new BigdataQuadWrapper((BigdataStatement)o));
            }
        };
    }

    private boolean hasMixedQuadData(List<StatementPatternNode> templates) {
        if (templates.size() == 0) {
            return false;
        }
        TermNode singleValue = templates.get(0).c();
        if (singleValue instanceof VarNode) {
            return true;
        }
        for (StatementPatternNode spn : templates) {
            TermNode tn = spn.c();
            if (this.equals(singleValue, tn)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(TermNode a, TermNode b) {
        return a == b || a != null && a.equals(b);
    }

    private IFilterTest createNativeDistinctTripleFilter(ConstructNode construct) {
        StatementPatternNode sp = this.templates.get(0);
        IVariableOrConstant<IV> s = sp.s().getValueExpression();
        IVariableOrConstant<IV> p = sp.p().getValueExpression();
        IVariableOrConstant<IV> o = sp.o().getValueExpression();
        BOp[] vars = new BOp[]{s, p, o};
        SPOPredicate pred = new SPOPredicate(vars, BOp.NOANNS);
        SPOKeyOrder indexKeyOrder = SPOKeyOrder.getKeyOrder(pred, 3);
        construct.setProperty("keyOrder", indexKeyOrder);
        return new NativeDistinctFilter.DistinctFilterImpl((IPropertySet)construct);
    }

    static boolean isObviouslyDistinct(boolean quads, List<StatementPatternNode> templates, GraphPatternGroup<?> whereClause) {
        Set<IVariable<?>> vars2;
        if (templates.isEmpty()) {
            return true;
        }
        if (templates.size() != 1 || whereClause.size() != 1) {
            return false;
        }
        if (!(whereClause.get(0) instanceof StatementPatternNode)) {
            return false;
        }
        StatementPatternNode sp1 = templates.get(0);
        StatementPatternNode sp2 = (StatementPatternNode)whereClause.get(0);
        Set<IVariable<?>> vars1 = StaticAnalysis.getSPOVariables(sp1);
        if (!vars1.equals(vars2 = StaticAnalysis.getSPOVariables(sp2))) {
            return false;
        }
        return !quads || sp2.c() != null || sp2.getScope() != StatementPattern.Scope.NAMED_CONTEXTS;
    }

    public boolean hasNext() throws QueryEvaluationException {
        while (this.buffer.isEmpty()) {
            if (!this.src.hasNext()) {
                this.close();
                return false;
            }
            this.fillBuffer((BindingSet)this.src.next());
        }
        return true;
    }

    public BigdataStatement next() throws QueryEvaluationException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buffer.removeFirst();
    }

    public void close() throws QueryEvaluationException {
        if (this.open) {
            this.open = false;
            this.src.close();
            if (this.filter instanceof ICloseable) {
                ((ICloseable)this.filter).close();
            }
        }
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    private void fillBuffer(BindingSet solution) {
        assert (this.buffer.isEmpty());
        if (!this.haveFirstSolution) {
            this.haveFirstSolution = true;
            for (BigdataStatement stmt : this.groundTriples) {
                this.addStatementToBuffer(stmt);
            }
        }
        Map<String, BigdataBNode> bnodes = this.getBNodeMap();
        int ngenerated = 0;
        for (StatementPatternNode pat : this.templates) {
            BigdataStatement stmt = this.makeStatement(pat, solution, bnodes);
            if (stmt == null) continue;
            this.addStatementToBuffer(stmt);
            ++ngenerated;
        }
        if (ngenerated == 0 && DEBUG) {
            log.debug((Object)("No statements generated for this solution: " + solution));
        }
    }

    private void addStatementToBuffer(BigdataStatement stmt) {
        if (DEBUG) {
            log.debug((Object)stmt.toString());
        }
        if (this.filter != null) {
            if (this.filter.isValid((Object)stmt)) {
                this.buffer.add(stmt);
            }
        } else {
            this.buffer.add(stmt);
        }
    }

    private BigdataStatement makeStatement(StatementPatternNode pat, BindingSet solution, Map<String, BigdataBNode> bnodes) {
        BigdataValue c;
        BigdataValue s = this.getValue(pat.s(), solution, bnodes);
        BigdataValue p = this.getValue(pat.p(), solution, bnodes);
        BigdataValue o = this.getValue(pat.o(), solution, bnodes);
        BigdataValue bigdataValue = c = pat.c() == null ? null : this.getValue(pat.c(), solution, bnodes);
        if (s == null || p == null || o == null) {
            return null;
        }
        if (!(s instanceof Resource)) {
            return null;
        }
        if (!(p instanceof URI)) {
            return null;
        }
        if (!(o instanceof Value)) {
            return null;
        }
        if (c != null && !(c instanceof Resource)) {
            return null;
        }
        return this.f.createStatement((Resource)s, (URI)p, o, (Resource)c);
    }

    private BigdataValue getValue(TermNode term, BindingSet solution, Map<String, BigdataBNode> bnodes) {
        if (term instanceof ConstantNode) {
            BigdataValue value = term.getValue();
            if (value == null) {
                throw new AssertionError((Object)("BigdataValue not available: " + term + ", term.iv=" + term.getValueExpression().get()));
            }
            if (value instanceof BigdataBNode) {
                if (this.bnodes != null) {
                    return value;
                }
                String id = ((BigdataBNode)value).getID();
                BigdataBNode bnode = this.getBNode(id, bnodes);
                return bnode;
            }
            return value;
        }
        if (term instanceof VarNode) {
            VarNode v = (VarNode)term;
            String varname = v.getValueExpression().getName();
            if (v.isAnonymous()) {
                return this.getBNode(varname, bnodes);
            }
            BigdataValue val = (BigdataValue)solution.getValue(varname);
            return val;
        }
        throw new UnsupportedOperationException("term: " + term);
    }

    private BigdataBNode getBNode(String id, Map<String, BigdataBNode> bnodes) {
        BigdataBNode tmp = bnodes.get(id);
        if (tmp != null) {
            return tmp;
        }
        BigdataBNode bnode = this.f.createBNode("b" + Integer.valueOf(this.bnodeIdFactory++).toString());
        bnodes.put(id, bnode);
        return bnode;
    }
}

