/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.FilterExistsModeEnum;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SubqueryRoot
extends SubqueryBase
implements IJoinNode {
    private static final long serialVersionUID = 1L;

    public SubqueryRoot(SubqueryRoot queryBase) {
        super(queryBase);
    }

    public SubqueryRoot(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public SubqueryRoot(QueryType queryType) {
        super(queryType);
    }

    public void setRunOnce(boolean runOnce) {
        this.setProperty("runOnce", runOnce);
    }

    public boolean isRunOnce() {
        return this.getProperty("runOnce", false);
    }

    public void setAskVar(IVariable<?> askVar) {
        this.setProperty("askVar", askVar);
    }

    public IVariable<?> getAskVar() {
        return (IVariable)this.getProperty("askVar");
    }

    public void setFilterExistsMode(FilterExistsModeEnum newVal) {
        this.setProperty("filterExists", (Object)newVal);
    }

    public FilterExistsModeEnum getFilterExistsMode() {
        return this.getProperty("filterExists", Annotations.DEFAULT_FILTER_EXISTS);
    }

    @Override
    public final boolean isOptional() {
        return false;
    }

    @Override
    public final boolean isMinus() {
        return false;
    }

    @Override
    public final List<FilterNode> getAttachedJoinFilters() {
        List filters = (List)this.getProperty("filters");
        if (filters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(filters);
    }

    @Override
    public final void setAttachedJoinFilters(List<FilterNode> filters) {
        this.setProperty("filters", filters);
    }

    @Override
    public String toString(int indent) {
        List<FilterNode> filters;
        IVariable<?> askVar;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        boolean runOnce = this.isRunOnce();
        sb.append("\n");
        sb.append(SubqueryRoot.indent(indent));
        if (runOnce) {
            sb.append("@runOnce=" + runOnce);
        }
        if ((askVar = this.getAskVar()) != null) {
            sb.append("@askVar=" + askVar);
        }
        if (!(filters = this.getAttachedJoinFilters()).isEmpty()) {
            for (FilterNode filter : filters) {
                sb.append(filter.toString(indent + 1));
            }
        }
        return sb.toString();
    }

    public static interface Annotations
    extends IJoinNode.Annotations {
        public static final String RUN_ONCE = "runOnce";
        public static final boolean DEFAULT_RUN_ONCE = false;
        public static final String ASK_VAR = "askVar";
        public static final String FILTER_EXISTS = "filterExists";
        public static final FilterExistsModeEnum DEFAULT_FILTER_EXISTS = QueryHints.DEFAULT_FILTER_EXISTS;
    }
}

